/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;

public class ItemUtils {
    public static final di EMPTY_ITEM = null;
    public static final ev EMPTY_STACK = null;
    private static final List<di> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM);

    public static ev getStackFrom(Object data) {
        ev itemStack = null;
        if (data != null) {
            if (data instanceof ly) {
                ly block = (ly)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof di) {
                di item = (di)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof ev) {
                ev stack;
                itemStack = stack = (ev)data;
            }
        }
        return itemStack;
    }

    public static di getItemFromStack(ev stack) {
        return stack != null ? stack.a() : EMPTY_ITEM;
    }

    public static int getStackCount(ev stack) {
        return stack != null ? stack.a : 0;
    }

    public static int getStackDamage(ev stack) {
        return stack != null ? stack.d : 0;
    }

    public static boolean isItemEmpty(Object data) {
        ev stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static ev getDefaultInstance(ly block) {
        return new ev(block);
    }

    public static ev getDefaultInstance(di item) {
        return new ev(item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        ev stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = MappingUtils.getClassName(stack.a());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

