/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import io.github.cdagaming.unicore.UniCore;
import io.github.cdagaming.unicore.impl.LockObject;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;

public class ScheduleUtils {
    public static final int MINIMUM_REFRESH_RATE = 2;
    public final LockObject TICK_LOCK = new LockObject();
    public int TIMER = 0;
    public Instant CURRENT_INSTANT = TimeUtils.getCurrentTime();
    private int refreshRate;
    private Runnable callbackEvent;
    private boolean isTiming = false;
    private boolean refreshedCallbacks = false;
    private Instant BEGINNING_INSTANT;
    private long ELAPSED_TIME = 0L;
    private long LAST_TICKED;

    public ScheduleUtils(int rate, Runnable event) {
        this.setRefreshRate(rate);
        this.setCallbackEvent(event);
        this.TICK_LOCK.unlock();
    }

    public ScheduleUtils(Runnable event) {
        this(2, event);
    }

    public void onTick() {
        this.ELAPSED_TIME = TimeUtils.getDurationFrom(this.CURRENT_INSTANT).getSeconds();
        if (this.TIMER > 0) {
            if (!this.isTiming) {
                this.startTimer();
            } else {
                this.checkTimer();
            }
        } else if (this.isTiming) {
            this.isTiming = false;
        }
        if (this.LAST_TICKED != this.ELAPSED_TIME && this.ELAPSED_TIME % (long)this.getRefreshRate() == 0L && !this.refreshedCallbacks) {
            this.refreshedCallbacks = true;
        }
    }

    public void postTick() {
        if (this.refreshedCallbacks) {
            try {
                this.TICK_LOCK.waitForUnlock((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$postTick$0(), ()V)((ScheduleUtils)this));
            }
            catch (Exception ex) {
                UniCore.LOG.error(ex);
            }
        }
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = Math.max(2, refreshRate);
    }

    public Runnable getCallbackEvent() {
        return this.callbackEvent;
    }

    public void setCallbackEvent(Runnable callbackEvent) {
        this.callbackEvent = callbackEvent;
    }

    private void startTimer() {
        this.BEGINNING_INSTANT = TimeUtils.getCurrentTime().plusSeconds(this.TIMER);
        this.isTiming = true;
    }

    private void checkTimer() {
        if (this.TIMER > 0) {
            long remainingTime = this.BEGINNING_INSTANT.getEpochSecond() - TimeUtils.getCurrentTime().getEpochSecond();
            this.TIMER = (int)remainingTime;
        }
    }

    private /* synthetic */ void lambda$postTick$0() {
        if (this.getCallbackEvent() != null) {
            this.getCallbackEvent().run();
        }
        this.LAST_TICKED = this.ELAPSED_TIME;
        this.refreshedCallbacks = false;
    }
}

