/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import io.github.cdagaming.unicore.impl.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final String DEFAULT_ZONE = "UTC";

    public static DateTimeFormatter getFormatter(String pattern, String timeZone) {
        return DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of(timeZone));
    }

    public static DateTimeFormatter getFormatter(String pattern) {
        return TimeUtils.getFormatter(pattern, DEFAULT_ZONE);
    }

    public static String toString(TemporalAccessor date, String pattern, String timeZone) {
        if (date == null) {
            return "";
        }
        return TimeUtils.getFormatter(pattern, timeZone).format(date);
    }

    public static String toString(TemporalAccessor date, String timeZone) {
        return TimeUtils.toString(date, timeZone, DEFAULT_ZONE);
    }

    public static <T> T toInstance(String dateString, String pattern, String timeZone, TemporalQuery<T> query) {
        return TimeUtils.getFormatter(pattern, timeZone).parse((CharSequence)dateString, query);
    }

    public static <T> T toInstance(String dateString, String pattern, TemporalQuery<T> query) {
        return TimeUtils.toInstance(dateString, pattern, DEFAULT_ZONE, query);
    }

    public static Instant toInstant(String dateString, String pattern, String timeZone) {
        return TimeUtils.toInstance(dateString, pattern, timeZone, (TemporalQuery<Instant>)LambdaMetafactory.metafactory(null, null, null, (Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;, from(java.time.temporal.TemporalAccessor ), (Ljava/time/temporal/TemporalAccessor;)Ljava/time/Instant;)());
    }

    public static Instant toInstant(String dateString, String pattern) {
        return TimeUtils.toInstant(dateString, pattern, DEFAULT_ZONE);
    }

    public static String convertTime(String dateString, String fromFormat, String fromTimeZone, String toFormat, String toTimeZone) {
        return TimeUtils.toString(TimeUtils.toInstant(dateString, fromFormat, fromTimeZone), toFormat, toTimeZone);
    }

    public static String convertFormat(String dateString, String fromFormat, String toFormat) {
        return TimeUtils.convertTime(dateString, fromFormat, DEFAULT_ZONE, toFormat, DEFAULT_ZONE);
    }

    public static String convertZone(String dateString, String fromFormat, String fromTimeZone, String toTimeZone) {
        return TimeUtils.convertTime(dateString, fromFormat, fromTimeZone, fromFormat, toTimeZone);
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime, long tickOffset, long ticksPerDay, long ticksPerHour, long ticksPerMinute) {
        long days = worldTime / ticksPerDay;
        long dayTicks = worldTime % ticksPerDay;
        if ((dayTicks += tickOffset) > ticksPerDay) {
            dayTicks -= ticksPerDay;
        }
        long hourTicks = dayTicks % ticksPerHour;
        long minuteTicks = hourTicks % ticksPerMinute;
        long hours = dayTicks / ticksPerHour;
        long minutes = hourTicks / ticksPerMinute;
        long seconds = minuteTicks * (60L / ticksPerMinute);
        long millis = ((hours * 60L + minutes) * 60L + seconds) * 1000L;
        return new Pair<Long, Instant>(days, Instant.ofEpochMilli(millis));
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime, long ticksPerDay, long ticksPerHour, long ticksPerMinute) {
        return TimeUtils.fromWorldTime(worldTime, 0L, ticksPerDay, ticksPerHour, ticksPerMinute);
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime) {
        return TimeUtils.fromWorldTime(worldTime, 6000L, 24000L, 1000L, 16L);
    }

    public static String epochSecondToString(long epochSecond, String pattern, String timeZone) {
        return TimeUtils.toString(TimeUtils.fromEpochSecond(epochSecond), pattern, timeZone);
    }

    public static String epochSecondToString(long epochSecond, String pattern) {
        return TimeUtils.epochSecondToString(epochSecond, pattern, DEFAULT_ZONE);
    }

    public static long stringToEpochSecond(String dateString, String pattern, String timeZone) {
        return TimeUtils.toEpochSecond(TimeUtils.toInstant(dateString, pattern, timeZone));
    }

    public static long stringToEpochSecond(String dateString, String pattern) {
        return TimeUtils.stringToEpochSecond(dateString, pattern, DEFAULT_ZONE);
    }

    public static String epochMilliToString(long epochMilli, String pattern, String timeZone) {
        return TimeUtils.toString(TimeUtils.fromEpochMilli(epochMilli), pattern, timeZone);
    }

    public static String epochMilliToString(long epochMilli, String pattern) {
        return TimeUtils.epochMilliToString(epochMilli, pattern, DEFAULT_ZONE);
    }

    public static long stringToEpochMilli(String dateString, String pattern, String timeZone) {
        return TimeUtils.toEpochMilli(TimeUtils.toInstant(dateString, pattern, timeZone));
    }

    public static long stringToEpochMilli(String dateString, String pattern) {
        return TimeUtils.stringToEpochMilli(dateString, pattern, DEFAULT_ZONE);
    }

    public static Instant fromEpochSecond(long epochSecond) {
        return Instant.ofEpochSecond(epochSecond);
    }

    public static Instant fromEpochMilli(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public static long toEpochSecond(Instant data) {
        return data != null ? data.getEpochSecond() : 0L;
    }

    public static long toEpochSecond() {
        return TimeUtils.toEpochSecond(TimeUtils.getCurrentTime());
    }

    public static long toEpochMilli(Instant data) {
        return data != null ? data.toEpochMilli() : 0L;
    }

    public static long toEpochMilli() {
        return TimeUtils.toEpochMilli(TimeUtils.getCurrentTime());
    }

    public static Instant getCurrentTime() {
        return Instant.now();
    }

    public static long getElapsedNanos() {
        return System.nanoTime();
    }

    public static long getElapsedMillis() {
        return TimeUtils.getElapsedNanos() / 1000000L;
    }

    public static long getElapsedSeconds() {
        return TimeUtils.getElapsedMillis() / 1000L;
    }

    public static Duration getDuration(Temporal start, Temporal end) {
        return Duration.between(start, end);
    }

    public static Duration getDurationFrom(Temporal start) {
        return TimeUtils.getDuration(start, TimeUtils.getCurrentTime());
    }

    public static Duration getDurationTo(Temporal end) {
        return TimeUtils.getDuration(TimeUtils.getCurrentTime(), end);
    }

    public static TemporalUnit getChronoUnitFrom(String name) {
        return ChronoUnit.valueOf(name.toUpperCase());
    }

    public static TimeUnit getTimeUnitFrom(String name) {
        return TimeUnit.valueOf(name.toUpperCase());
    }

    public static Temporal appendTime(Temporal temporal, long amount, TemporalUnit unit) {
        return temporal.plus(amount, unit);
    }

    public static Temporal appendTime(Temporal temporal, long amount, String unit) {
        return TimeUtils.appendTime(temporal, amount, TimeUtils.getChronoUnitFrom(unit));
    }
}

