/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityList;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.nbt.NBTBase;
import net.minecraft.src.game.nbt.NBTTagByte;
import net.minecraft.src.game.nbt.NBTTagByteArray;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.nbt.NBTTagDouble;
import net.minecraft.src.game.nbt.NBTTagFloat;
import net.minecraft.src.game.nbt.NBTTagInt;
import net.minecraft.src.game.nbt.NBTTagIntArray;
import net.minecraft.src.game.nbt.NBTTagList;
import net.minecraft.src.game.nbt.NBTTagLong;
import net.minecraft.src.game.nbt.NBTTagShort;
import net.minecraft.src.game.nbt.NBTTagString;

public class NbtUtils {
    public static NBTTagCompound getNbt(Entity entity) {
        return entity != null ? NbtUtils.serializeNBT(entity) : new NBTTagCompound();
    }

    public static NBTTagCompound getNbt(ItemStack stack) {
        NBTTagCompound result = new NBTTagCompound();
        return stack != null ? stack.writeToNBT(result) : result;
    }

    public static NBTBase getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            Entity entity = (Entity)data;
            return NbtUtils.getNbt(entity, path);
        }
        if (data instanceof ItemStack) {
            ItemStack stack = (ItemStack)data;
            return NbtUtils.getNbt(stack, path);
        }
        return null;
    }

    public static NBTBase getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static NBTBase getNbt(ItemStack stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static NBTBase getNbt(NBTTagCompound root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        NBTTagCompound currentTag = root;
        block0: for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof NBTTagCompound) {
                NBTTagCompound temp = currentTag;
                for (Object item : temp.func_28110_c()) {
                    NBTBase nbt = (NBTBase)item;
                    if (!nbt.getKey().equals(path[i])) continue;
                    currentTag = nbt;
                    continue block0;
                }
                continue;
            }
            if (currentTag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)currentTag;
                int index = Integer.parseInt(path[i]);
                currentTag = list.tagAt(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(NBTBase tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getType()) {
            case 1: {
                return ((NBTTagByte)tag).byteValue;
            }
            case 2: {
                return ((NBTTagShort)tag).shortValue;
            }
            case 3: {
                return ((NBTTagInt)tag).intValue;
            }
            case 4: {
                return ((NBTTagLong)tag).longValue;
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)tag).floatValue);
            }
            case 6: {
                return ((NBTTagDouble)tag).doubleValue;
            }
            case 7: {
                return ((NBTTagByteArray)tag).byteArray;
            }
            case 8: {
                return ((NBTTagString)tag).stringValue;
            }
            case 9: {
                NBTTagList list = (NBTTagList)tag;
                List converted = StringUtils.newArrayList();
                if (list.tagCount() <= 0) {
                    for (int i = 0; i < list.tagCount(); ++i) {
                        converted.add(NbtUtils.parseTag(list.tagAt(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    return tag.toString();
                }
            }
            case 11: {
                return ((NBTTagIntArray)tag).intArray;
            }
        }
        return tag;
    }

    public static NBTTagCompound serializeNBT(Entity entity) {
        String name = EntityList.getEntityString((Entity)entity);
        NBTTagCompound ret = new NBTTagCompound();
        if (!StringUtils.isNullOrEmpty(name)) {
            ret.setString("id", name);
        }
        entity.writeToNBT(ret);
        return ret;
    }
}

