/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityList;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldInfo;

public class WorldUtils {
    public static World getWorld(Minecraft client) {
        return client != null ? client.theWorld : null;
    }

    public static World getWorld(Entity entity) {
        return entity != null ? entity.worldObj : null;
    }

    public static EntityPlayer getPlayer(Minecraft client) {
        return client != null ? client.thePlayer : null;
    }

    public static String getEntityName(Entity entity, boolean stripFormatting) {
        String result = "";
        if (entity != null) {
            result = StringUtils.getOrDefault(EntityList.getEntityString((Entity)entity));
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getEntityName(Entity entity) {
        return WorldUtils.getEntityName(entity, true);
    }

    public static String getWeather(World world) {
        String name = "clear";
        if (world != null) {
            WorldInfo info = world.getWorldInfo();
            name = info.getThundering() ? "thunder" : (info.getRaining() ? "rain" : "clear");
        }
        return name;
    }

    public static String getWeather(Entity entity) {
        return WorldUtils.getWeather(WorldUtils.getWorld(entity));
    }
}

