/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;

public class ItemUtils {
    public static final gk EMPTY_ITEM = null;
    public static final iw EMPTY_STACK = null;
    private static final List<gk> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM);

    public static iw getStackFrom(Object data) {
        iw itemStack = null;
        if (data != null) {
            if (data instanceof un) {
                un block = (un)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof gk) {
                gk item = (gk)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof iw) {
                iw stack;
                itemStack = stack = (iw)data;
            }
        }
        return itemStack;
    }

    public static gk getItemFromStack(iw stack) {
        return stack != null ? stack.a() : EMPTY_ITEM;
    }

    public static int getStackCount(iw stack) {
        return stack != null ? stack.a : 0;
    }

    public static int getStackDamage(iw stack) {
        return stack != null ? stack.i() : 0;
    }

    public static boolean isItemEmpty(Object data) {
        iw stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static iw getDefaultInstance(un block) {
        return new iw(block);
    }

    public static iw getDefaultInstance(gk item) {
        return new iw(item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        iw stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = StringUtils.getOrDefault(stack.a().k());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

