/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTextField
extends tw {
    private static final String allowedChars = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_'abcdefghijklmnopqrstuvwxyz{|}~\u2302\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb";
    private final se fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    public String text;
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    public String arrow = "";
    public int lineScrollOffset = 0;
    public int cursorPosition = 0;
    public int selectionEnd = 0;
    private boolean isTextSelected;

    public GuiTextField(se fontRenderer, int x, int y, int w, int h, String s) {
        this.fontRenderer = fontRenderer;
        this.xPos = x;
        this.yPos = y;
        this.width = w;
        this.height = h;
        this.setText(s);
        this.setCursorPosition(s.length());
    }

    public void setText(String s) {
        this.text = s;
    }

    public void setArrow(String s) {
        this.arrow = s;
    }

    public String getText() {
        return this.text;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void writeText(String text) {
        int n;
        String newText = "";
        int posend = Math.min(this.cursorPosition, this.selectionEnd);
        int selend = Math.max(this.cursorPosition, this.selectionEnd);
        int end = this.maxStringLength - this.text.length() - (posend - this.selectionEnd);
        if (!this.text.isEmpty()) {
            newText = GuiTextField.jvmdowngrader$concat$writeText$1(newText, this.text.substring(0, posend));
        }
        if (end < text.length()) {
            newText = GuiTextField.jvmdowngrader$concat$writeText$1(newText, text.substring(0, end));
            n = end;
        } else {
            newText = GuiTextField.jvmdowngrader$concat$writeText$1(newText, text);
            n = text.length();
        }
        if (!this.text.isEmpty() && selend < this.text.length()) {
            newText = GuiTextField.jvmdowngrader$concat$writeText$1(newText, this.text.substring(selend));
        }
        this.text = newText;
        this.moveCursorBy(posend - this.selectionEnd + n);
    }

    public void deleteFromCursor(int i) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean charExists = i < 0;
                int pos = charExists ? this.cursorPosition + i : this.cursorPosition;
                int neg = charExists ? this.cursorPosition : this.cursorPosition + i;
                String newtext = "";
                if (pos >= 0) {
                    newtext = this.text.substring(0, pos);
                }
                if (neg < this.text.length()) {
                    newtext = GuiTextField.jvmdowngrader$concat$writeText$1(newtext, this.text.substring(neg));
                }
                this.text = newtext;
                if (charExists) {
                    this.moveCursorBy(i);
                }
            }
        }
    }

    public void moveCursorBy(int i) {
        this.setCursorPosition(this.selectionEnd + i);
    }

    public void setCursorPosition(int i) {
        this.cursorPosition = i;
        int length = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > length) {
            this.cursorPosition = length;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setSelectionPos(int i) {
        int length = this.text.length();
        if (i > length) {
            i = length;
        }
        if (i < 0) {
            i = 0;
        }
        this.selectionEnd = i;
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > length) {
                this.lineScrollOffset = length;
            }
            int max = this.width - 20;
            String sw = RenderUtils.trimStringToWidth(this.fontRenderer, this.text.substring(this.lineScrollOffset), max);
            int inoffs = sw.length() + this.lineScrollOffset;
            if (i == this.lineScrollOffset) {
                this.lineScrollOffset -= RenderUtils.trimStringToWidth(this.fontRenderer, this.text, max, true).length();
            }
            if (i > inoffs) {
                this.lineScrollOffset += i - inoffs;
            } else if (i <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - i;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > length) {
                this.lineScrollOffset = length;
            }
        }
    }

    public void textboxKeyTyped(char eventChar, int eventKey) {
        if (this.isEnabled && this.isFocused) {
            if (eventChar == '\u0003') {
                ExtendedScreen.copyToClipboard(this.text);
            } else if (eventChar == '\u0016') {
                this.writeText(cy.d());
            } else if (eventChar == '\u0018') {
                ExtendedScreen.copyToClipboard(this.text);
                this.writeText("");
            }
            if (eventKey == 14) {
                this.deleteFromCursor(-1);
                if (this.isTextSelected) {
                    this.text = "";
                    this.writeText("");
                    this.isTextSelected = false;
                }
            } else if (eventKey == 28) {
                this.isFocused = false;
            } else if (eventKey == 203) {
                this.moveCursorBy(-1);
                this.isTextSelected = false;
            } else if (eventKey == 205) {
                this.moveCursorBy(1);
                this.isTextSelected = false;
            } else if (eventKey == 211) {
                this.deleteFromCursor(1);
            } else {
                if (!this.text.isEmpty() && Keyboard.isKeyDown((int)29) && eventKey == 30) {
                    this.isTextSelected = true;
                    this.setCursorPosition(this.text.length());
                    this.setSelectionPos(0);
                }
                if (allowedChars.indexOf(eventChar) >= 0 && this.text.length() < this.maxStringLength) {
                    this.writeText(GuiTextField.jvmdowngrader$concat$textboxKeyTyped$1(eventChar));
                }
                if (Keyboard.getEventKey() == 59 && this.text.length() < this.maxStringLength) {
                    this.writeText("\u00a7");
                }
                if (this.isTextSelected) {
                    if (allowedChars.indexOf(eventChar) >= 0 && this.text.length() < this.maxStringLength) {
                        this.text = "";
                        this.writeText(GuiTextField.jvmdowngrader$concat$textboxKeyTyped$1(eventChar));
                        this.isTextSelected = false;
                    }
                    if (eventChar == '\u0016') {
                        int length;
                        String str = cy.d();
                        if (str == null) {
                            str = "";
                        }
                        if ((length = this.maxStringLength - this.text.length()) > str.length()) {
                            length = str.length();
                        }
                        if (length > 0) {
                            this.text = "";
                            this.writeText(str.substring(0, length));
                            this.isTextSelected = false;
                        }
                    }
                }
            }
        }
    }

    public void mouseClicked(int x, int y, int button) {
        boolean state = this.isEnabled && x >= this.xPos && x < this.xPos + this.width && y >= this.yPos && y < this.yPos + this.height;
        this.setFocused(state);
        this.isTextSelected = false;
        if (this.isFocused && state && button == 0) {
            int l = x - this.xPos;
            String string = RenderUtils.trimStringToWidth(this.fontRenderer, this.text.substring(this.lineScrollOffset), this.width);
            this.setCursorPosition(RenderUtils.trimStringToWidth(this.fontRenderer, string, l).length() + this.lineScrollOffset);
        }
    }

    public void setFocused(boolean bool) {
        if (bool && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = bool;
    }

    public void drawTextBox() {
        this.a(this.xPos - 1, this.yPos - 1, this.xPos + this.width + 1, this.yPos + this.height + 1, -6250336);
        this.a(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -16777216);
        this.renderText(this.xPos + 4, this.yPos + (this.height - 8) / 2, this.yPos - 2 + (this.height - 8) / 2, this.yPos + (this.height + 12) / 2);
    }

    public void renderSelectedTextBG(String strOffset, int mny, int mxy) {
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        this.a(2 + this.fontRenderer.a(this.arrow) + this.xPos, mny, this.fontRenderer.a(GuiTextField.jvmdowngrader$concat$writeText$1(this.arrow, strOffset)) + 6 + this.xPos, mxy, Color.BLUE.getRGB());
        GL11.glDisable((int)3058);
    }

    public void renderText(int x, int y, int bgmny, int bgmxy) {
        if (this.isFocused && this.isEnabled) {
            String strOffset = RenderUtils.trimStringToWidth(this.fontRenderer, this.text.substring(this.lineScrollOffset), this.width - 8);
            int strWidth = this.fontRenderer.a(GuiTextField.jvmdowngrader$concat$writeText$1(this.arrow, strOffset));
            int selOffs = this.selectionEnd - this.lineScrollOffset;
            if (selOffs > strOffset.length()) {
                selOffs = strOffset.length();
            }
            this.b(this.fontRenderer, GuiTextField.jvmdowngrader$concat$writeText$1(this.arrow, strOffset), x, y, 0xE0E0E0);
            if (this.cursorCounter / 6 % 2 == 0) {
                if (this.cursorPosition == this.text.length()) {
                    this.b(this.fontRenderer, "_", x + (strWidth > 0 ? strWidth + 2 : 0), y, 0xE0E0E0);
                } else {
                    int selX = x + this.fontRenderer.a(GuiTextField.jvmdowngrader$concat$writeText$1(this.arrow, strOffset.substring(0, selOffs)));
                    this.a(selX, y - 1, selX + 1, y + 1 + 8, -3092272);
                }
            }
            if (this.isTextSelected) {
                this.renderSelectedTextBG(strOffset, bgmny, bgmxy);
            }
        } else {
            this.b(this.fontRenderer, RenderUtils.trimStringToWidth(this.fontRenderer, this.text, this.width - 8), x, y, this.isEnabled ? 0xE0E0E0 : 0x707070);
        }
    }

    public void setMaxStringLength(int num) {
        this.maxStringLength = num;
    }

    private static String jvmdowngrader$concat$writeText$1(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$textboxKeyTyped$1(char c) {
        return "" + c;
    }
}

