/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;

public class ItemUtils {
    public static final sv EMPTY_ITEM = null;
    public static final ul EMPTY_STACK = null;
    private static final List<sv> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM);

    public static ul getStackFrom(Object data) {
        ul itemStack = null;
        if (data != null) {
            if (data instanceof lr) {
                lr block = (lr)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof sv) {
                sv item = (sv)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof ul) {
                ul stack;
                itemStack = stack = (ul)data;
            }
        }
        return itemStack;
    }

    public static sv getItemFromStack(ul stack) {
        return stack != null ? stack.a() : EMPTY_ITEM;
    }

    public static int getStackCount(ul stack) {
        return stack != null ? stack.a : 0;
    }

    public static int getStackDamage(ul stack) {
        return stack != null ? stack.i() : 0;
    }

    public static boolean isItemEmpty(Object data) {
        ul stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static ul getDefaultInstance(lr block) {
        return new ul(block);
    }

    public static ul getDefaultInstance(sv item) {
        return new ul(item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        ul stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = StringUtils.getOrDefault(stack.a().k());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

