/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScissorStack;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenRectangle;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import com.gitlab.cdagaming.unilib.utils.ImageUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class RenderUtils {
    private static final ScissorStack scissorStack = new ScissorStack();
    private static final List<ul> BLOCKED_RENDER_ITEMS = StringUtils.newArrayList();
    private static final Map<String, Tuple<Boolean, String, String>> TEXTURE_CACHE = StringUtils.newHashMap();
    private static final pj itemRender = new pj();

    public static String getScreenTexture(@Nonnull Minecraft mc, int protocol) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultGUIBackground(protocol)).getThird();
    }

    public static String getScreenTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getScreenTexture(mc, ModUtils.MCProtocolID);
    }

    public static String getButtonTexture(@Nonnull Minecraft mc, int protocol) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultButtonBackground(protocol)).getThird();
    }

    public static String getButtonTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getButtonTexture(mc, ModUtils.MCProtocolID);
    }

    public static boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return MathUtils.isWithinValue(mouseY, topIn, bottomIn, true, true) && MathUtils.isWithinValue(mouseX, leftIn, rightIn, true, true);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return MathUtils.isWithinValue(mouseX, elementX, elementX + elementWidth, true, false) && MathUtils.isWithinValue(mouseY, elementY, elementY + elementHeight, true, false);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, DynamicWidget widget) {
        return RenderUtils.isMouseOver(mouseX, mouseY, widget.getControlPosX(), widget.getControlPosY(), widget.getControlWidth() - 1, widget.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)button);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return textControl.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)textControl);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedScreen screen) {
        return screen.isLoaded() && RenderUtils.isMouseOver(mouseX, mouseY, screen.getScreenX(), screen.getScreenY(), screen.getScreenWidth(), screen.getScreenHeight());
    }

    public static boolean isMouseOver(ExtendedScreen screen) {
        return RenderUtils.isMouseOver((double)screen.getMouseX(), (double)screen.getMouseY(), screen);
    }

    public static kh getDefaultFontRenderer() {
        return ModUtils.getMinecraft().q;
    }

    public static void openScreen(final @Nonnull Minecraft client, final qr targetScreen) {
        client.a(new qr(){

            public void a() {
            }

            public void a(int i, int j, float par3) {
                client.a(targetScreen);
            }
        });
    }

    public static void openScreen(@Nonnull Minecraft client, ExtendedScreen targetScreen, qr parentScreen, boolean setParent) {
        if (setParent) {
            targetScreen.setParent(parentScreen);
        }
        RenderUtils.openScreen(client, targetScreen);
    }

    public static void openScreen(@Nonnull Minecraft client, ExtendedScreen targetScreen, qr parentScreen) {
        RenderUtils.openScreen(client, targetScreen, parentScreen, targetScreen.getParent() == null);
    }

    public static void drawItemStack(@Nonnull Minecraft client, kh fontRenderer, int x, int y, ul stack, float scale) {
        block3: {
            if (BLOCKED_RENDER_ITEMS.contains(stack)) {
                return;
            }
            try {
                GL11.glPushMatrix();
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2929);
                RenderUtils.func_41089_c();
                int xPos = Math.round((float)x / scale);
                int yPos = Math.round((float)y / scale);
                itemRender.a(fontRenderer, client.p, stack, xPos, yPos);
                itemRender.b(fontRenderer, client.p, stack, xPos, yPos);
                ow.a();
                GL11.glDisable((int)2929);
                GL11.glDisable((int)2903);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                if (BLOCKED_RENDER_ITEMS.contains(stack)) break block3;
                BLOCKED_RENDER_ITEMS.add(stack);
            }
        }
    }

    public static void func_41089_c() {
        GL11.glPushMatrix();
        GL11.glRotatef((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ow.b();
        GL11.glPopMatrix();
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        double canvasWidth = width - (double)(border * 2);
        double canvasHeight = height - (double)(border * 2);
        double canvasRight = posX + (double)border + canvasWidth;
        double canvasBottom = posY + (double)border + canvasHeight;
        if (borderColor != null) {
            RenderUtils.drawGradient(posX, posX + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(canvasRight, canvasRight + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, canvasBottom, canvasBottom + (double)border, zLevel, borderColorEnd, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, posY, posY + (double)border, zLevel, borderColor, borderColor);
        }
        if (contentColor != null) {
            RenderUtils.drawGradient(posX + (double)border, canvasRight, posY + (double)border, canvasBottom, zLevel, contentColor, contentColorEnd);
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, 0, contentColor, contentColorEnd);
    }

    public static void renderButton(@Nonnull Minecraft mc, double x, double y, double startU, double startV, double endU, double endV, double width, double height, double zLevel, String texLocation) {
        block5: {
            try {
                if (ResourceUtils.isValidResource(texLocation)) {
                    Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                    if (data.getFirst().booleanValue()) {
                        GL11.glBindTexture((int)3553, (int)data.getSecond());
                    } else {
                        GL11.glBindTexture((int)3553, (int)mc.p.b(texLocation));
                    }
                    break block5;
                }
                return;
            }
            catch (Exception ignored) {
                return;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        RenderUtils.blit(x, y, zLevel, startU, startV, width, height);
        RenderUtils.blit(x + width, y, zLevel, endU, endV, width, height);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3042);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, String texLocation) {
        block7: {
            if (!asFullTexture) {
                RenderUtils.drawGradient(left, right, top, bottom, zLevel, startColorObj, endColorObj);
                return;
            }
            try {
                if (ResourceUtils.isValidResource(texLocation)) {
                    Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                    if (data.getFirst().booleanValue()) {
                        GL11.glBindTexture((int)3553, (int)data.getSecond());
                    } else {
                        GL11.glBindTexture((int)3553, (int)mc.p.b(texLocation));
                    }
                    break block7;
                }
                return;
            }
            catch (Exception ignored) {
                return;
            }
        }
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        xe tessellator = xe.a;
        tessellator.b();
        tessellator.a(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
        tessellator.a(left, bottom, zLevel, minU, maxV);
        tessellator.a(right, bottom, zLevel, maxU, maxV);
        tessellator.a(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        tessellator.a(right, top, zLevel, maxU, minV);
        tessellator.a(left, top, zLevel, minU, minV);
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, true, minU, maxU, minV, maxV, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, asFullTexture, RenderUtils.getUVCoord(u + 0.0, 0.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(u + regionWidth, 1.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(v + 0.0, 0.0, usingExternalTexture, textureHeight), RenderUtils.getUVCoord(v + regionHeight, 1.0, usingExternalTexture, textureHeight), startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, true, usingExternalTexture, regionWidth, regionHeight, u, v, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, right - left, bottom - top, left, top, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, true, usingExternalTexture, startColorObj, endColorObj, texLocation);
    }

    public static void drawGradient(double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        xe tessellator = xe.a;
        tessellator.b();
        tessellator.a(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
        tessellator.a(left, bottom, zLevel);
        tessellator.a(right, bottom, zLevel);
        tessellator.a(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        tessellator.a(right, top, zLevel);
        tessellator.a(left, top, zLevel);
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(xPos, yPos, zLevel, u, v, regionWidth, regionHeight, 256.0, 256.0);
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.blit(xPos, xPos + regionWidth, yPos, yPos + regionHeight, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(left, right, top, bottom, zLevel, RenderUtils.getUVCoord(u + 0.0, textureWidth), RenderUtils.getUVCoord(u + regionWidth, textureWidth), RenderUtils.getUVCoord(v + 0.0, textureHeight), RenderUtils.getUVCoord(v + regionHeight, textureHeight));
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        xe tessellator = xe.a;
        tessellator.b();
        tessellator.a(left, bottom, zLevel, minU, maxV);
        tessellator.a(right, bottom, zLevel, maxU, maxV);
        tessellator.a(right, top, zLevel, maxU, minV);
        tessellator.a(left, top, zLevel, minU, minV);
        tessellator.a();
    }

    public static void enableScissor(@Nonnull Minecraft mc, int left, int top, int right, int bottom) {
        RenderUtils.applyScissor(mc, scissorStack.push(new ScreenRectangle(left, top, right - left, bottom - top)));
    }

    public static void disableScissor(@Nonnull Minecraft mc) {
        RenderUtils.applyScissor(mc, scissorStack.pop());
    }

    private static void applyScissor(@Nonnull Minecraft mc, ScreenRectangle rectangle) {
        if (rectangle != null) {
            int scale = RenderUtils.computeGuiScale(mc);
            int displayHeight = mc.e;
            int renderWidth = Math.max(0, rectangle.width() * scale);
            int renderHeight = Math.max(0, rectangle.height() * scale);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(rectangle.getLeft() * scale), (int)(displayHeight - rectangle.getBottom() * scale), (int)renderWidth, (int)renderHeight);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public static int computeGuiScale(@Nonnull Minecraft mc) {
        int scaleFactor = 1;
        int k2 = mc.z.N;
        if (k2 == 0) {
            k2 = 1000;
        }
        while (scaleFactor < k2 && mc.d / (scaleFactor + 1) >= 320 && mc.e / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static Tuple<Boolean, String, String> getTextureData(@Nonnull Minecraft mc, String texture) {
        String texLocation = ResourceUtils.getEmptyResource();
        Tuple<Boolean, String, String> result = new Tuple<Boolean, String, String>(false, "", texLocation);
        if (!StringUtils.isNullOrEmpty(texture)) {
            if (TEXTURE_CACHE.containsKey(texture = texture.trim())) {
                return TEXTURE_CACHE.get(texture);
            }
        } else {
            return result;
        }
        boolean usingExternalTexture = false;
        if (!StringUtils.isValidColorCode(texture)) {
            usingExternalTexture = ImageFrame.isExternalImage(texture);
            if (!usingExternalTexture) {
                if (texture.startsWith(":")) {
                    texture = texture.substring(1);
                }
                if (texture.contains(":")) {
                    String[] splitInput = texture.split(":", 2);
                    texLocation = ResourceUtils.getResource(splitInput[0], splitInput[1]);
                } else {
                    texLocation = ResourceUtils.getResource(texture);
                }
            } else {
                String formattedConvertedName = texture.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.trim().split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                texLocation = ImageUtils.getTextureFromUrl(mc, textureName, texture.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
            }
        }
        result.put(usingExternalTexture, texture, texLocation);
        if (!usingExternalTexture) {
            TEXTURE_CACHE.put(texture, result);
        }
        return result;
    }

    public static void drawMultiLineString(@Nonnull Minecraft mc, List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, kh fontRenderer, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        if (colorInfo.renderTooltips() && !textToInput.isEmpty() && fontRenderer != null) {
            boolean usingExternalTexture;
            Tuple<Boolean, String, String> textureData;
            List<String> textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = RenderUtils.getStringWidth(fontRenderer, textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean allowXAdjustments = maxWidth > 0;
            boolean allowYAdjustments = maxHeight > 0;
            boolean allowCenterAdjustments = isCentered && allowXAdjustments;
            int titleLinesCount = 1;
            int tooltipX = posX;
            if (!isTooltip && allowCenterAdjustments) {
                tooltipX = posX + 4;
                tooltipTextWidth = maxWidth - tooltipX - 4;
            } else if (isTooltip) {
                tooltipX = posX + (allowXAdjustments ? 12 : 0);
                if (allowXAdjustments && tooltipX + tooltipTextWidth + 4 > maxWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = posX > maxWidth / 2 ? posX - 12 - 8 : maxWidth - 16 - posX;
                    needsWrap = true;
                }
                if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                    tooltipTextWidth = maxTextWidth;
                    needsWrap = true;
                }
            }
            if (needsWrap) {
                List wrappedTextLines = StringUtils.newArrayList();
                int wrappedTooltipWidth = 0;
                for (int i = 0; i < textLines.size(); ++i) {
                    List<String> wrappedLine = RenderUtils.listFormattedStringToWidth(fontRenderer, textLines.get(i), tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                if (allowXAdjustments) {
                    tooltipX = posX > maxWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
                }
            }
            int tooltipY = posY - (isTooltip && allowYAdjustments ? 12 : 0);
            int tooltipHeight = 8;
            int fontHeight = RenderUtils.getFontHeight(fontRenderer);
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * (fontHeight + 1);
                if (isTooltip && textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (allowYAdjustments) {
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > maxHeight) {
                    tooltipY = maxHeight - tooltipHeight - 4;
                }
            }
            ScreenConstants.ColorData backgroundColorInfo = colorInfo.backgroundColor();
            ScreenConstants.ColorData borderColorInfo = colorInfo.borderColor();
            int zLevel = 300;
            if (backgroundColorInfo != null) {
                Color backgroundStart = backgroundColorInfo.startColor();
                Color backgroundEnd = backgroundColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(backgroundColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 300.0, backgroundStart, backgroundEnd, 1, -1, backgroundStart, backgroundEnd);
                } else {
                    textureData = RenderUtils.getTextureData(mc, backgroundColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    String backGroundTexture = textureData.getThird();
                    double width = tooltipTextWidth + 4;
                    double height = tooltipHeight + 4;
                    double left = tooltipX - 4;
                    double right = (double)tooltipX + width;
                    double top = tooltipY - 4;
                    double bottom = (double)tooltipY + height;
                    RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, usingExternalTexture, backgroundStart, backgroundEnd, backGroundTexture);
                }
            }
            if (borderColorInfo != null) {
                Color borderStart = borderColorInfo.startColor();
                Color borderEnd = borderColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(borderColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 300.0, borderStart, borderEnd, 1, null, null);
                } else {
                    textureData = RenderUtils.getTextureData(mc, borderColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    String borderTexture = textureData.getThird();
                    double border = 1.0;
                    double renderX = tooltipX - 3;
                    double renderY = tooltipY - 3;
                    double canvasRight = tooltipX + tooltipTextWidth + 2;
                    double canvasBottom = tooltipY + tooltipHeight + 2;
                    RenderUtils.drawTexture(mc, renderX, renderX + 1.0, renderY, canvasBottom + 1.0, 300.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, canvasRight, canvasRight + 1.0, renderY, canvasBottom + 1.0, 300.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, canvasBottom, canvasBottom + 1.0, 300.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, renderY, renderY + 1.0, 300.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                }
            }
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                int renderX = isCentered ? tooltipX + (tooltipTextWidth - lineWidth) / 2 : tooltipX;
                RenderUtils.renderString(fontRenderer, line, renderX, tooltipY, -1);
                if (isTooltip && lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += fontHeight + 1;
            }
        }
    }

    public static void renderCenteredString(kh fontRenderer, String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(fontRenderer, text, xPos - (float)RenderUtils.getStringWidth(fontRenderer, text) / 2.0f, yPos, color);
    }

    public static void renderCenteredString(kh fontRenderer, String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(fontRenderer, text, xPos - RenderUtils.getStringWidth(fontRenderer, text) / 2, yPos, color);
    }

    public static void renderString(kh fontRenderer, String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(fontRenderer, text, Math.round(xPos), Math.round(yPos), color);
    }

    public static void renderString(kh fontRenderer, String text, int xPos, int yPos, int color) {
        fontRenderer.a(text, xPos, yPos, color);
    }

    public static int getStringWidth(kh fontRenderer, String string) {
        return fontRenderer.a(string);
    }

    private static int getCharWidth(kh fontRenderer, char string) {
        return RenderUtils.getStringWidth(fontRenderer, String.valueOf(string));
    }

    public static int getFontHeight(kh fontRenderer) {
        return 8;
    }

    public static void renderScrollingString(@Nonnull Minecraft mc, kh fontRenderer, String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        float renderY = (minY + maxY - (float)RenderUtils.getFontHeight(fontRenderer)) / 2.0f + 1.0f;
        float elementWidth = maxX - minX;
        if ((float)lineWidth > elementWidth) {
            float renderWidth = (float)lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(mc, (int)minX, (int)minY, (int)maxX, (int)maxY);
            RenderUtils.renderString(fontRenderer, message, minX - (float)offset, renderY, color);
            RenderUtils.disableScissor(mc);
        } else {
            float renderX = MathUtils.clamp(centerX, minX + (float)lineWidth / 2.0f, maxX - (float)lineWidth / 2.0f);
            RenderUtils.renderCenteredString(fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull Minecraft mc, kh fontRenderer, String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        int renderY = (minY + maxY - RenderUtils.getFontHeight(fontRenderer)) / 2 + 1;
        int elementWidth = maxX - minX;
        if (lineWidth > elementWidth) {
            int renderWidth = lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(mc, minX, minY, maxX, maxY);
            RenderUtils.renderString(fontRenderer, message, minX - (int)offset, renderY, color);
            RenderUtils.disableScissor(mc);
        } else {
            int renderX = MathUtils.clamp(centerX, minX + lineWidth / 2, maxX - lineWidth / 2);
            RenderUtils.renderCenteredString(fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull Minecraft mc, kh fontRenderer, String message, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(mc, fontRenderer, message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(@Nonnull Minecraft mc, kh fontRenderer, String message, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(mc, fontRenderer, message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public static double getUVCoord(double primary, double secondary, boolean usingExternalTexture, double textureSize) {
        return usingExternalTexture ? secondary : RenderUtils.getUVCoord(primary, textureSize);
    }

    public static double getUVCoord(double primary, double textureSize) {
        return primary / textureSize;
    }

    public static List<String> listFormattedStringToWidth(kh fontRenderer, String stringInput, int wrapWidth) {
        return StringUtils.splitTextByNewLine(RenderUtils.wrapFormattedStringToWidth(fontRenderer, stringInput, wrapWidth), true);
    }

    private static String wrapFormattedStringToWidth(kh fontRenderer, String stringInput, int wrapWidth) {
        int stringSizeToWidth = RenderUtils.sizeStringToWidth(fontRenderer, stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = RenderUtils.jvmdowngrader$concat$wrapFormattedStringToWidth$1(StringUtils.getFormatFromString(subString), stringInput.substring(stringSizeToWidth + (flag ? 1 : 0)));
        return RenderUtils.jvmdowngrader$concat$wrapFormattedStringToWidth$2(subString, RenderUtils.wrapFormattedStringToWidth(fontRenderer, s1, wrapWidth));
    }

    private static int sizeStringToWidth(kh fontRenderer, String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            switch (currentCharacter) {
                case '\n': {
                    --currentLine;
                    break;
                }
                case ' ': {
                    currentIndex = currentLine;
                }
                default: {
                    charWidth += RenderUtils.getCharWidth(fontRenderer, currentCharacter);
                    if (!flag) break;
                    ++charWidth;
                    break;
                }
                case '\u00a7': {
                    char code;
                    if (currentLine >= stringLength - 1) break;
                    if ((code = stringEntry.charAt(++currentLine)) == 'l' || code == 'L') {
                        flag = true;
                        break;
                    }
                    if (code != 'r' && code != 'R' && !StringUtils.isFormatColor(code)) break;
                    flag = false;
                }
            }
            if (currentCharacter == '\n') {
                currentIndex = ++currentLine;
                break;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }

    public static String trimStringToWidth(kh fontRenderer, String text, int width) {
        return RenderUtils.trimStringToWidth(fontRenderer, text, width, false);
    }

    public static String trimStringToWidth(kh fontRenderer, String text, int width, boolean reverse) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        int j = reverse ? text.length() - 1 : 0;
        int k2 = reverse ? -1 : 1;
        boolean flag = false;
        boolean flag1 = false;
        for (int l = j; l >= 0 && l < text.length() && i < width; l += k2) {
            char c0 = text.charAt(l);
            int i1 = fontRenderer.a(String.valueOf(c0));
            if (flag) {
                flag = false;
                if (c0 == 'l' || c0 == 'L') {
                    flag1 = true;
                } else if (c0 == 'r' || c0 == 'R') {
                    flag1 = false;
                }
            } else if (i1 < 0) {
                flag = true;
            } else {
                i += i1;
                if (flag1) {
                    ++i;
                }
            }
            if (i > width) break;
            if (reverse) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private static String jvmdowngrader$concat$wrapFormattedStringToWidth$1(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$wrapFormattedStringToWidth$2(String string, String string2) {
        return string + "\n" + string2;
    }
}

