/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import unilib.external.com.twelvemonkeys.imageio.color.YCbCrConverter;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.BoolDecoder;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.LoopFilter;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.MacroBlock;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.SegmentQuants;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.vp8.SubBlock;

public final class VP8Frame {
    private static final int BLOCK_TYPES = 4;
    private static final int COEF_BANDS = 8;
    private static final int MAX_ENTROPY_TOKENS = 12;
    private static final int MAX_MODE_LF_DELTAS = 4;
    private static final int MAX_REF_LF_DELTAS = 4;
    private static final int PREV_COEF_CONTEXTS = 3;
    private IIOReadProgressListener listener = null;
    private final int[][][][] coefProbs;
    private int filterLevel;
    private final ImageInputStream frame;
    private final boolean debug;
    private int frameType;
    private int height;
    private int macroBlockCols;
    private int macroBlockNoCoeffSkip;
    private int macroBlockRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private final int[] modeLoopFilterDeltas = new int[4];
    private int modeRefLoopFilterDeltaEnabled;
    private int modeRefLoopFilterDeltaUpdate;
    private int multiTokenPartition = 0;
    private long offset;
    private final int[] refLoopFilterDeltas = new int[4];
    private int refreshEntropyProbs;
    private int refreshLastFrame;
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private boolean simpleFilter;
    private BoolDecoder tokenBoolDecoder;
    private final List<BoolDecoder> tokenBoolDecoders;
    private int updateMacroBlockSegmentationMap;
    private int updateMacroBlockSegmentatonData;
    private int width;
    private final byte[] yuv = new byte[3];
    private final byte[] rgb = new byte[4];

    public VP8Frame(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.frame = imageInputStream;
        this.debug = bl;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.tokenBoolDecoders = new ArrayList<BoolDecoder>();
    }

    public void setProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listener = iIOReadProgressListener;
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.macroBlockRows + 2][this.macroBlockCols + 2];
        for (int i = 0; i < this.macroBlockRows + 2; ++i) {
            for (int j = 0; j < this.macroBlockCols + 2; ++j) {
                this.macroBlocks[i][j] = new MacroBlock(j, i, this.debug);
            }
        }
    }

    public boolean decode(WritableRaster writableRaster, ImageReadParam imageReadParam) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        this.segmentQuants = new SegmentQuants();
        int n5 = this.frame.readUnsignedByte();
        this.frameType = this.getBitAsInt(n5, 0);
        if (this.frameType != 0) {
            return false;
        }
        int n6 = this.getBitAsInt(n5, 1) << 1;
        n6 += this.getBitAsInt(n5, 2) << 1;
        n6 += this.getBitAsInt(n5, 3);
        int n7 = this.getBitAsInt(n5, 5);
        n7 += this.getBitAsInt(n5, 6) << 1;
        n7 += this.getBitAsInt(n5, 7) << 2;
        n5 = this.frame.readUnsignedByte();
        n7 += n5 << 3;
        n5 = this.frame.readUnsignedByte();
        n7 += n5 << 11;
        n5 = this.frame.readUnsignedByte();
        n5 = this.frame.readUnsignedByte();
        n5 = this.frame.readUnsignedByte();
        int n8 = n5 = this.frame.readUnsignedByte();
        n5 = this.frame.readUnsignedByte();
        this.width = (n8 += n5 << 8) & 0x3FFF;
        int n9 = n5 = this.frame.readUnsignedByte();
        n5 = this.frame.readUnsignedByte();
        this.height = (n9 += n5 << 8) & 0x3FFF;
        int n10 = this.width;
        int n11 = this.height;
        if ((n10 & 0xF) != 0) {
            n10 += 16 - (n10 & 0xF);
        }
        if ((n11 & 0xF) != 0) {
            n11 += 16 - (n11 & 0xF);
        }
        this.macroBlockRows = n11 >> 4;
        this.macroBlockCols = n10 >> 4;
        this.createMacroBlocks();
        this.offset = this.frame.getStreamPosition();
        BoolDecoder boolDecoder = new BoolDecoder(this.frame, this.offset);
        if (this.frameType == 0) {
            n4 = boolDecoder.readBit();
            n3 = boolDecoder.readBit();
        }
        this.segmentationIsEnabled = boolDecoder.readBit();
        if (this.segmentationIsEnabled > 0) {
            this.updateMacroBlockSegmentationMap = boolDecoder.readBit();
            this.updateMacroBlockSegmentatonData = boolDecoder.readBit();
            if (this.updateMacroBlockSegmentatonData > 0) {
                this.macroBlockSegementAbsoluteDelta = boolDecoder.readBit();
                for (n4 = 0; n4 < 4; ++n4) {
                    n3 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n3 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[0]);
                        if (boolDecoder.readBit() > 0) {
                            n3 = -n3;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n4].setQindex(n3);
                }
                for (n4 = 0; n4 < 4; ++n4) {
                    n3 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n3 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[1]);
                        if (boolDecoder.readBit() > 0) {
                            n3 = -n3;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n4].setFilterStrength(n3);
                }
                if (this.updateMacroBlockSegmentationMap > 0) {
                    this.macroBlockSegmentTreeProbs = new int[3];
                    for (n4 = 0; n4 < 3; ++n4) {
                        this.macroBlockSegmentTreeProbs[n4] = n3 = boolDecoder.readBit() > 0 ? boolDecoder.readLiteral(8) : 255;
                    }
                }
            }
        }
        this.simpleFilter = boolDecoder.readBit() != 0;
        this.filterLevel = boolDecoder.readLiteral(6);
        this.sharpnessLevel = boolDecoder.readLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = boolDecoder.readBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0) {
            this.modeRefLoopFilterDeltaUpdate = boolDecoder.readBit();
            if (this.modeRefLoopFilterDeltaUpdate > 0) {
                for (n4 = 0; n4 < 4; ++n4) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n4] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n4] = this.refLoopFilterDeltas[n4] * -1;
                }
                for (n4 = 0; n4 < 4; ++n4) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n4] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n4] = this.modeLoopFilterDeltas[n4] * -1;
                }
            }
        }
        this.setupTokenDecoder(boolDecoder, n7, this.offset);
        boolDecoder.seek();
        this.segmentQuants.parse(boolDecoder, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        if (this.frameType != 0) {
            throw new IllegalArgumentException("Bad input: Not an Intra frame");
        }
        this.refreshEntropyProbs = boolDecoder.readBit();
        if (this.refreshEntropyProbs > 0) {
            // empty if block
        }
        this.refreshLastFrame = 0;
        this.refreshLastFrame = this.frameType == 0 ? 1 : boolDecoder.readBit();
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 8; ++n3) {
                for (int i = 0; i < 3; ++i) {
                    for (n2 = 0; n2 < 11; ++n2) {
                        if (boolDecoder.readBool(Globals.vp8CoefUpdateProbs[n4][n3][i][n2]) <= 0) continue;
                        this.coefProbs[n4][n3][i][n2] = n = boolDecoder.readLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = boolDecoder.readBit();
        if (this.frameType != 0) {
            throw new IIOException("Bad input: Not an Intra frame");
        }
        this.readModes(boolDecoder);
        n4 = 0;
        n3 = 1 << this.multiTokenPartition;
        Rectangle rectangle = imageReadParam != null && imageReadParam.getSourceRegion() != null ? imageReadParam.getSourceRegion() : writableRaster.getBounds();
        n2 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        n = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        for (int i = 0; i < this.macroBlockRows; ++i) {
            if (n3 > 1) {
                this.tokenBoolDecoder = this.tokenBoolDecoders.get(n4);
                this.tokenBoolDecoder.seek();
                if (++n4 == n3) {
                    n4 = 0;
                }
            }
            this.decodeMacroBlockRow(i, writableRaster, rectangle, n2, n);
            this.fireProgressUpdate(i);
        }
        return true;
    }

    private void decodeMacroBlockRow(int n, WritableRaster writableRaster, Rectangle rectangle, int n2, int n3) throws IOException {
        boolean bl = this.filterLevel != 0;
        MacroBlock macroBlock = null;
        MacroBlock[] macroBlockArray = this.macroBlocks[n];
        MacroBlock[] macroBlockArray2 = this.macroBlocks[n + 1];
        for (int i = 0; i < this.macroBlockCols; ++i) {
            MacroBlock macroBlock2 = macroBlockArray2[i + 1];
            macroBlock2.decodeMacroBlock(this);
            macroBlock2.dequantMacroBlock(this);
            if (bl) {
                MacroBlock macroBlock3 = n > 0 ? macroBlockArray[i + 1] : null;
                LoopFilter.loopFilterBlock(macroBlock2, macroBlock, macroBlock3, this.frameType, this.simpleFilter, this.sharpnessLevel);
            }
            this.copyBlock(macroBlock2, writableRaster, rectangle, n2, n3);
            macroBlock = macroBlock2;
        }
    }

    private void fireProgressUpdate(int n) {
        if (this.listener != null) {
            float f = 100.0f * ((float)(n + 1) / (float)this.getMacroBlockRows());
            this.listener.imageProgress(null, f);
        }
    }

    public SubBlock getAboveRightSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        MacroBlock macroBlock = subBlock.getMacroBlock();
        int n = macroBlock.getSubblockX(subBlock);
        int n2 = macroBlock.getSubblockY(subBlock);
        if (plane == SubBlock.Plane.Y1) {
            if (n2 == 0 && n < 3) {
                MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
                SubBlock subBlock2 = macroBlock2.getSubBlock(plane, n + 1, 3);
                return subBlock2;
            }
            if (n2 == 0 && n == 3) {
                MacroBlock macroBlock3 = this.getMacroBlock(macroBlock.getX() + 1, macroBlock.getY() - 1);
                SubBlock subBlock3 = macroBlock3.getSubBlock(plane, 0, 3);
                if (macroBlock3.getX() == this.getMacroBlockCols()) {
                    int[][] nArray = new int[4][4];
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            nArray[j][i] = macroBlock3.getY() < 0 ? 127 : this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1).getSubBlock(SubBlock.Plane.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    subBlock3 = new SubBlock(macroBlock3, null, null, SubBlock.Plane.Y1);
                    subBlock3.setDest(nArray);
                }
                return subBlock3;
            }
            if (n2 > 0 && n < 3) {
                SubBlock subBlock4 = macroBlock.getSubBlock(plane, n + 1, n2 - 1);
                return subBlock4;
            }
            SubBlock subBlock5 = macroBlock.getSubBlock(subBlock.getPlane(), 3, 0);
            return this.getAboveRightSubBlock(subBlock5, plane);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getAboveSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        SubBlock subBlock2 = subBlock.getAbove();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n = macroBlock.getSubblockX(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
            while (plane == SubBlock.Plane.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX(), macroBlock2.getY() - 1);
            }
            subBlock2 = macroBlock2.getBottomSubBlock(n, subBlock.getPlane());
        }
        return subBlock2;
    }

    private int getBitAsInt(int n, int n2) {
        int n3 = n & 1 << n2;
        if (n3 != 0) {
            return 1;
        }
        return 0;
    }

    int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public BufferedImage getDebugImageDiff() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int[] nArray = new int[3];
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.Y1, i % 16 / 4, j % 16 / 4).getDiff()[i % 4][j % 4];
                int n2 = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int n3 = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n - 16) + 1.596 * (double)(n3 - 128));
                nArray[1] = (int)(1.164 * (double)(n - 16) - 0.813 * (double)(n3 - 128) - 0.391 * (double)(n2 - 128));
                nArray[2] = (int)(1.164 * (double)(n - 16) + 2.018 * (double)(n2 - 128));
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImagePredict() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int[] nArray = new int[3];
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.Y1, i % 16 / 4, j % 16 / 4).getPredict()[i % 4][j % 4];
                int n2 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int n3 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n - 16) + 1.596 * (double)(n3 - 128));
                nArray[1] = (int)(1.164 * (double)(n - 16) - 0.813 * (double)(n3 - 128) - 0.391 * (double)(n2 - 128));
                nArray[2] = (int)(1.164 * (double)(n - 16) + 2.018 * (double)(n2 - 128));
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.Y1, i % 16 / 4, j % 16 / 4).getDest()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.Y1, i % 16 / 4, j % 16 / 4).getDiff()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.Plane.Y1, i % 16 / 4, j % 16 / 4).getPredict()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (nArray[i2] < 0) {
                        nArray[i2] = 0;
                    }
                    if (nArray[i2] <= 255) continue;
                    nArray[i2] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return bufferedImage;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public SubBlock getLeftSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        SubBlock subBlock2 = subBlock.getLeft();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n = macroBlock.getSubblockY(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX() - 1, macroBlock.getY());
            while (plane == SubBlock.Plane.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX() - 1, macroBlock2.getY());
            }
            subBlock2 = macroBlock2.getRightSubBlock(n, subBlock.getPlane());
        }
        return subBlock2;
    }

    public MacroBlock getMacroBlock(int n, int n2) {
        return this.macroBlocks[n2 + 1][n + 1];
    }

    public int getMacroBlockCols() {
        return this.macroBlockCols;
    }

    public String getMacroBlockDebugString(int n, int n2, int n3, int n4) {
        String string = "";
        if (n < this.macroBlockCols && n2 < this.getMacroBlockRows()) {
            MacroBlock macroBlock = this.getMacroBlock(n, n2);
            string = string + macroBlock.getDebugString();
            if (n3 < 4 && n4 < 4) {
                SubBlock subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n3, n4);
                string = string + "\n SubBlock " + n3 + ", " + n4 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y2, n3, n4);
                string = string + "\n SubBlock " + n3 + ", " + n4 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.U, n3 / 2, n4 / 2);
                string = string + "\n SubBlock " + n3 / 2 + ", " + n4 / 2 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.V, n3 / 2, n4 / 2);
                string = string + "\n SubBlock " + n3 / 2 + ", " + n4 / 2 + "\n  " + subBlock.getDebugString();
            }
        }
        return string;
    }

    public int getMacroBlockRows() {
        return this.macroBlockRows;
    }

    public int getQIndex() {
        return this.segmentQuants.getqIndex();
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public BoolDecoder getTokenBoolDecoder() throws IOException {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    private void readModes(BoolDecoder boolDecoder) throws IOException {
        int n = -1;
        int n2 = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            n2 = boolDecoder.readLiteral(8);
        }
        while (++n < this.macroBlockRows) {
            int n3 = -1;
            while (++n3 < this.macroBlockCols) {
                SubBlock subBlock;
                int n4;
                int n5;
                int n6;
                MacroBlock macroBlock = this.getMacroBlock(n3, n);
                if (this.segmentationIsEnabled > 0 && this.updateMacroBlockSegmentationMap > 0) {
                    n6 = boolDecoder.readTree(Globals.macroBlockSegmentTree, this.macroBlockSegmentTreeProbs, 0);
                    macroBlock.setSegmentId(n6);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    n6 = this.filterLevel;
                    n6 = (n6 += this.refLoopFilterDeltas[0]) < 0 ? 0 : Math.min(n6, 63);
                    macroBlock.setFilterLevel(n6);
                } else {
                    macroBlock.setFilterLevel(this.segmentQuants.getSegQuants()[macroBlock.getSegmentId()].getFilterStrength());
                }
                n6 = this.macroBlockNoCoeffSkip > 0 ? boolDecoder.readBool(n2) : 0;
                macroBlock.setSkipCoeff(n6);
                int n7 = this.readYMode(boolDecoder);
                macroBlock.setYMode(n7);
                if (n7 == 4) {
                    for (n5 = 0; n5 < 4; ++n5) {
                        for (n4 = 0; n4 < 4; ++n4) {
                            SubBlock subBlock2 = macroBlock.getYSubBlock(n4, n5);
                            subBlock = this.getAboveSubBlock(subBlock2, SubBlock.Plane.Y1);
                            SubBlock subBlock3 = this.getLeftSubBlock(subBlock2, SubBlock.Plane.Y1);
                            int n8 = this.readSubBlockMode(boolDecoder, subBlock.getMode(), subBlock3.getMode());
                            subBlock2.setMode(n8);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        n5 = macroBlock.getFilterLevel();
                        n5 = (n5 += this.modeLoopFilterDeltas[0]) < 0 ? 0 : Math.min(n5, 63);
                        macroBlock.setFilterLevel(n5);
                    }
                } else {
                    switch (n7) {
                        case 1: {
                            n5 = 2;
                            break;
                        }
                        case 2: {
                            n5 = 3;
                            break;
                        }
                        case 3: {
                            n5 = 1;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    for (n4 = 0; n4 < 4; ++n4) {
                        for (int i = 0; i < 4; ++i) {
                            subBlock = macroBlock.getYSubBlock(n4, i);
                            subBlock.setMode(n5);
                        }
                    }
                }
                n5 = this.readUvMode(boolDecoder);
                macroBlock.setUvMode(n5);
            }
        }
    }

    private int readPartitionSize(long l) throws IOException {
        this.frame.seek(l);
        return this.frame.readUnsignedByte() + (this.frame.readUnsignedByte() << 8) + (this.frame.readUnsignedByte() << 16);
    }

    private int readSubBlockMode(BoolDecoder boolDecoder, int n, int n2) throws IOException {
        return boolDecoder.readTree(Globals.vp8SubBlockModeTree, Globals.vp8KeyFrameSubBlockModeProb[n][n2], 0);
    }

    private int readUvMode(BoolDecoder boolDecoder) throws IOException {
        return boolDecoder.readTree(Globals.vp8UVModeTree, Globals.vp8KeyFrameUVModeProb, 0);
    }

    private int readYMode(BoolDecoder boolDecoder) throws IOException {
        return boolDecoder.readTree(Globals.vp8KeyFrameYModeTree, Globals.vp8KeyFrameYModeProb, 0);
    }

    private void setupTokenDecoder(BoolDecoder boolDecoder, int n, long l) throws IOException {
        long l2;
        long l3 = l2 = l + (long)n;
        this.multiTokenPartition = boolDecoder.readLiteral(2);
        int n2 = 1 << this.multiTokenPartition;
        if (n2 > 1) {
            l3 += 3L * (long)(n2 - 1);
        }
        for (int i = 0; i < n2; ++i) {
            long l4;
            if (i < n2 - 1) {
                l4 = this.readPartitionSize(l2 + (long)i * 3L);
                boolDecoder.seek();
            } else {
                l4 = this.frame.length() - l3;
            }
            this.tokenBoolDecoders.add(new BoolDecoder(this.frame, l3));
            l3 += l4;
        }
        this.tokenBoolDecoder = this.tokenBoolDecoders.get(0);
    }

    private void copyBlock(MacroBlock macroBlock, WritableRaster writableRaster, Rectangle rectangle, int n, int n2) {
        int n3 = macroBlock.getY() * 16 - rectangle.y;
        int n4 = Math.min(16, writableRaster.getHeight() * n2 - n3);
        int n5 = macroBlock.getX() * 16 - rectangle.x;
        int n6 = Math.min(16, writableRaster.getWidth() * n - n5);
        for (int i = 0; i < n4; i += n2) {
            int n7 = (n3 + i) / n2;
            if (n7 < 0) continue;
            for (int j = 0; j < n6; j += n) {
                int n8 = (n5 + j) / n;
                if (n8 < 0) continue;
                this.yuv[0] = (byte)macroBlock.getSubBlock(SubBlock.Plane.Y1, j / 4, i / 4).getDest()[j % 4][i % 4];
                this.yuv[1] = (byte)macroBlock.getSubBlock(SubBlock.Plane.U, j / 2 / 4, i / 2 / 4).getDest()[j / 2 % 4][i / 2 % 4];
                this.yuv[2] = (byte)macroBlock.getSubBlock(SubBlock.Plane.V, j / 2 / 4, i / 2 / 4).getDest()[j / 2 % 4][i / 2 % 4];
                YCbCrConverter.convertRec601YCbCr2RGB(this.yuv, this.rgb, 0);
                writableRaster.setDataElements(n8, n7, this.rgb);
            }
        }
    }
}

