/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class ExtendedButtonControl
extends Button
implements DynamicWidget {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private boolean isOverScreen = false;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (Component)Component.m_237113_((String)buttonText), button -> {}, Button.f_252438_);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), x, y, widthIn, heightIn, buttonText, optionalArgs);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(id, xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        this.isOverScreen = RenderUtils.isMouseOver(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.isOverScreen() && this.isHoveringOver()) {
            this.onHover();
        }
    }

    public void m_86412_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = ModUtils.getMinecraft();
        if (mc != null && this.isControlVisible()) {
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.m_7906_(matrixStack, mc, mouseX, mouseY);
            int color = !this.isControlEnabled() ? 0xA0A0A0 : (this.isHoveringOrFocusingOver() ? 0xFFFFA0 : 0xE0E0E0);
            RenderUtils.renderScrollingString(matrixStack, mc, mc.f_91062_, this.getControlMessage(), this.getLeft() + 2, this.getTop(), this.getRight() - 2, this.getBottom(), color);
        }
    }

    protected void m_7906_(@Nonnull PoseStack matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            int hoverState = this.m_7202_(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            double xOffset = (double)this.getControlWidth() / 2.0;
            RenderUtils.renderButton(mc, this.getControlPosX(), this.getControlPosY(), 0.0, hoverValue, 200.0 - xOffset, hoverValue, xOffset, this.getControlHeight(), this.getZLevel(), RenderUtils.getButtonTexture(mc));
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.isOverScreen() && this.isControlEnabled() && this.isControlVisible() && this.isHoveringOver();
    }

    @Override
    public int getControlWidth() {
        return this.f_93618_;
    }

    @Override
    public void setControlWidth(int width) {
        this.f_93618_ = width;
    }

    @Override
    public int getControlHeight() {
        return this.f_93619_;
    }

    @Override
    public void setControlHeight(int height) {
        this.f_93619_ = height;
    }

    @Override
    public int getControlPosX() {
        return this.m_252754_();
    }

    @Override
    public void setControlPosX(int posX) {
        this.m_252865_(posX);
    }

    @Override
    public int getControlPosY() {
        return this.m_252907_();
    }

    @Override
    public void setControlPosY(int posY) {
        this.m_252888_(posY);
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void m_5691_() {
        this.onClick();
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public Component getControlRawMessage() {
        return this.m_6035_();
    }

    public void setControlRawMessage(Component newMessage) {
        this.m_93666_(newMessage);
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((Component)Component.m_237113_((String)newMessage));
    }

    public boolean isControlEnabled() {
        return this.f_93623_;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.f_93623_ = isEnabled;
    }

    public boolean isControlVisible() {
        return this.f_93624_;
    }

    public void setControlVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public boolean isHoveringOver() {
        return this.f_93622_;
    }

    public void setHoveringOver(boolean isHovered) {
        this.f_93622_ = isHovered;
    }

    public boolean isFocusedOver() {
        return this.m_93696_();
    }

    public void setFocusedOver(boolean isFocused) {
        this.m_93692_(isFocused);
    }

    public boolean isHoveringOrFocusingOver() {
        return this.isHoveringOver() || this.isFocusedOver();
    }

    public double getZLevel() {
        return this.m_93252_();
    }

    public void setZLevel(double zLevel) {
        this.m_93250_((int)zLevel);
    }
}

