/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8028;

public abstract class EntryListPane<E extends Entry<E>>
extends ScrollPane {
    private static final class_2561 USAGE_NARRATION = class_2561.method_43471((String)"narration.selection.usage");
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int headerHeight;
    private boolean renderHeader;
    @Nullable
    private E selected;
    @Nullable
    private E hovered;

    public EntryListPane(class_310 client, int width, int height, int y, int itemHeight) {
        super(0, y, width, height);
        this.setGameInstance(client);
        this.setCanModifyControls(false);
        this.itemHeight = itemHeight;
    }

    protected void setRenderHeader(boolean renderHeader, int headerHeight) {
        this.renderHeader = renderHeader;
        this.headerHeight = headerHeight;
        if (!renderHeader) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
    }

    public E getFirstElement() {
        return this.getEntry(0);
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    @Nullable
    public class_8016 method_48205(@Nonnull class_8023 arg) {
        if (this.getItemCount() == 0) {
            return null;
        }
        if (this.method_25370() && arg instanceof class_8023.class_8024) {
            class_8023.class_8024 lv = (class_8023.class_8024)arg;
            E nextEntry = this.nextEntry(lv.comp_1191());
            return nextEntry != null ? class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193(nextEntry)) : null;
        }
        if (!this.method_25370()) {
            E selected = this.getSelected();
            if (selected == null) {
                selected = this.nextEntry(arg.method_48231());
            }
            return selected == null ? null : class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193(selected));
        }
        return null;
    }

    @Override
    public void method_37056(@Nonnull class_6382 arg) {
        E hovered = this.getHovered();
        if (hovered != null) {
            this.narrateListElementPosition(arg.method_37031(), hovered);
            ((Entry)hovered).method_37020(arg);
        } else {
            E selected = this.getSelected();
            if (selected != null) {
                this.narrateListElementPosition(arg.method_37031(), selected);
                ((Entry)selected).method_37020(arg);
            }
        }
        if (this.method_25370()) {
            arg.method_37034(class_6381.field_33791, USAGE_NARRATION);
        }
    }

    public final List<E> method_25396() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    protected void replaceEntries(Collection<E> collection) {
        this.clearEntries();
        this.children.addAll(collection);
    }

    protected E getEntry(int index) {
        return (E)((Entry)this.children.get(index));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.getItemCount() - 1;
    }

    protected void addEntryToTop(E entry) {
        float delta = (float)this.getMaxScroll() - this.getAmountScrolled();
        this.children.addFirst(entry);
        this.setAmountScrolled((float)this.getMaxScroll() - delta);
    }

    protected boolean removeEntryFromTop(E entry) {
        float delta = (float)this.getMaxScroll() - this.getAmountScrolled();
        boolean hasRemoved = this.removeEntry(entry);
        this.setAmountScrolled((float)this.getMaxScroll() - delta);
        return hasRemoved;
    }

    protected int getItemCount() {
        return this.children.size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.getEntry(index));
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int rowMiddle = this.getRowWidth() / 2;
        int listMiddle = this.getScreenX() + this.getScreenWidth() / 2;
        int left = listMiddle - rowMiddle;
        int right = listMiddle + rowMiddle;
        int yPos = (int)Math.floor(mouseY - (double)this.getScreenY() - (double)this.headerHeight + (double)this.getAmountScrolled() - (double)this.getPadding());
        int index = yPos / this.itemHeight;
        return mouseX >= (double)left && mouseX <= (double)right && index >= 0 && yPos >= 0 && index < this.getItemCount() ? (E)this.getEntry(index) : null;
    }

    public void updateSizeAndPosition(int width, int height, int yPos) {
        this.setScreenWidth(width);
        this.setScreenHeight(height);
        this.setScreenX(0);
        this.setScreenY(yPos);
        this.bindAmountScrolled();
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected boolean clickedHeader(int posX, int posY) {
        return false;
    }

    protected void renderHeader(class_332 arg, class_310 client, int posX, int posY) {
    }

    protected void renderDecorations(class_332 arg, class_310 client, int posX, int posY) {
    }

    @Override
    public void preRender() {
        super.preRender();
        this.hovered = this.isOverScreen() ? this.getEntryAtPosition(this.getMouseX(), this.getMouseY()) : null;
    }

    @Override
    public void postRender() {
        super.postRender();
        this.renderDecorations(this.getCurrentMatrix(), this.getGameInstance(), this.getMouseX(), this.getMouseY());
    }

    @Override
    public void renderExtra() {
        super.renderExtra();
        if (this.renderHeader) {
            int posX = this.getRowLeft();
            int posY = this.getScreenY() + this.getPadding() - (int)this.getAmountScrolled();
            this.renderHeader(this.getCurrentMatrix(), this.getGameInstance(), posX, posY);
        }
        this.renderListItems(this.getCurrentMatrix(), this.getGameInstance(), this.getMouseX(), this.getMouseY(), this.getPartialTicks());
    }

    protected void centerScrollOn(E entry) {
        this.setScroll((float)(this.method_25396().indexOf(entry) * this.itemHeight) + (float)this.itemHeight / 2.0f - (float)this.getScreenHeight() / 2.0f);
    }

    protected void ensureVisible(E entry) {
        int k;
        int rowTop = this.getRowTop(this.method_25396().indexOf(entry));
        int j = rowTop - this.getScreenY() - this.getPadding() - this.itemHeight;
        if (j < 0) {
            this.scrollBy(j);
        }
        if ((k = this.getBottom() - rowTop - this.itemHeight - this.itemHeight) < 0) {
            this.scrollBy(-k);
        }
    }

    @Override
    public int getContentHeight() {
        return this.getMaxPosition();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getScreenHeight() - this.getPadding()));
    }

    @Override
    public int getScrollBarX() {
        return this.getDefaultScrollbarPosition();
    }

    protected int getDefaultScrollbarPosition() {
        return this.getRealRowRight() + this.getListOutlinePadding();
    }

    private int getListOutlinePadding() {
        return 10;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (!this.isValidMouseClick(mouseButton)) {
            return false;
        }
        this.checkScrollbarClick(mouseX, mouseY, mouseButton);
        if (!this.isOverScreen()) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            if (((Entry)entry).method_25402(mouseX, mouseY, mouseButton)) {
                E focused = this.getFocused();
                if (focused != entry && focused instanceof class_4069) {
                    class_4069 containerEventHandler = (class_4069)focused;
                    containerEventHandler.method_25395(null);
                }
                this.method_25395((class_364)entry);
                return true;
            }
        } else if (this.clickedHeader((int)(mouseX - (double)(this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.getScreenY()) + (int)this.getAmountScrolled() - this.getPadding())) {
            return true;
        }
        return this.isScrolling();
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.setScrolling(false);
        return this.getFocused() != null && this.getFocused().method_25406(mouseX, mouseY, mouseButton);
    }

    public void method_25395(@Nullable class_364 arg) {
        super.method_25395(arg);
        int index = this.method_25396().indexOf(arg);
        if (index >= 0) {
            E entry = this.getEntry(index);
            this.setSelected(entry);
            if (this.getGameInstance().method_48186().method_48183()) {
                this.ensureVisible(entry);
            }
        }
    }

    @Override
    public int getHeightPerScroll() {
        return this.itemHeight / 2;
    }

    private int directionToInt(class_8028 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_8028.field_41829, class_8028.field_41828 -> 0;
            case class_8028.field_41826 -> -1;
            case class_8028.field_41827 -> 1;
        };
    }

    @Nullable
    protected E nextEntry(int direction) {
        return (E)this.nextEntry(direction, (E entry) -> true);
    }

    @Nullable
    protected E nextEntry(class_8028 direction) {
        return this.nextEntry(this.directionToInt(direction));
    }

    @Nullable
    protected E nextEntry(int direction, Predicate<E> predicate) {
        return this.nextEntry(direction, predicate, this.getSelected());
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate) {
        return this.nextEntry(this.directionToInt(direction), predicate);
    }

    @Nullable
    protected E nextEntry(int direction, Predicate<E> predicate, @Nullable E entry) {
        if (!this.method_25396().isEmpty() && direction != 0) {
            int index = entry == null ? (direction > 0 ? 0 : this.method_25396().size() - 1) : this.method_25396().indexOf(entry) + direction;
            for (int i = index; i >= 0 && i < this.getItemCount(); i += direction) {
                Entry next = (Entry)this.method_25396().get(i);
                if (!predicate.test(next)) continue;
                return (E)next;
            }
        }
        return null;
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate, @Nullable E entry) {
        return this.nextEntry(this.directionToInt(direction), predicate, entry);
    }

    protected void moveSelection(int direction) {
        E entry;
        E e = entry = direction != 0 ? this.nextEntry(direction) : this.getSelected();
        if (entry != null) {
            this.method_25395((class_364)entry);
            this.ensureVisible(entry);
        }
    }

    protected void moveSelection(class_8028 direction) {
        this.moveSelection(this.directionToInt(direction));
    }

    protected void renderListItems(class_332 arg, class_310 client, int mouseX, int mouseY, float partialTicks) {
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int rowHeight = this.itemHeight - this.getPadding();
        for (int index = 0; index < this.getItemCount(); ++index) {
            int rowTop = this.getRowTop(index);
            int rowBottom = this.getRowBottom(index);
            if (rowBottom < this.getScreenY() || rowTop > this.getBottom()) continue;
            this.renderItem(arg, client, mouseX, mouseY, partialTicks, index, rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    protected void renderItem(class_332 arg, class_310 client, int mouseX, int mouseY, float partialTicks, int index, int xPos, int yPos, int entryWidth, int entryHeight) {
        E entry = this.getEntry(index);
        ((Entry)entry).renderBack(arg, client, index, yPos, xPos, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.getHovered(), entry), partialTicks);
        if (this.isSelectedItem(index)) {
            int outerColor = this.method_25370() ? -1 : -8355712;
            this.renderSelection(client, yPos, entryWidth, entryHeight, outerColor, -16777216);
        }
        ((Entry)entry).render(arg, client, index, yPos, xPos, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.getHovered(), entry), partialTicks);
    }

    protected void renderSelection(class_310 client, int yPos, int width, int height, int outerColor, int innerColor) {
        int left = this.getScreenX() + (this.getScreenWidth() - width) / 2;
        int right = this.getScreenX() + (this.getScreenWidth() + width) / 2;
        RenderUtils.drawGradient(left, right, yPos - 2, yPos + height + 2, 0.0, outerColor, outerColor);
        RenderUtils.drawGradient(left + 1, right - 1, yPos - 1, yPos + height + 1, 0.0, innerColor, innerColor);
    }

    public int getRowLeft() {
        return this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2 + 2;
    }

    private int getRealRowLeft() {
        return this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    private int getRealRowRight() {
        return this.getRealRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return this.getScreenY() + this.getPadding() - (int)this.getAmountScrolled() + index * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    @Override
    @Nonnull
    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.getHovered() != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    @Nullable
    protected E remove(int index) {
        E entry = this.getEntry(index);
        return (E)(this.removeEntry(entry) ? entry : null);
    }

    protected boolean removeEntry(E entry) {
        boolean hasRemoved = this.children.remove(entry);
        if (hasRemoved && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return hasRemoved;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> entry) {
        entry.list = this;
    }

    protected void narrateListElementPosition(class_6382 output, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            output.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = StringUtils.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int index) {
            return (Entry)this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int index, E entry) {
            Entry prevEntry = (Entry)this.delegate.set(index, entry);
            EntryListPane.this.bindEntryToSelf(entry);
            return prevEntry;
        }

        @Override
        public void add(int index, E entry) {
            this.delegate.add(index, entry);
            EntryListPane.this.bindEntryToSelf(entry);
        }

        @Override
        public E remove(int index) {
            return (Entry)this.delegate.remove(index);
        }
    }

    protected static abstract class Entry<E extends Entry<E>>
    implements class_364,
    class_6383 {
        @Deprecated
        EntryListPane<E> list;

        protected Entry() {
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return this.list.getFocused() == this;
        }

        public abstract class_2561 getNarration();

        public void method_37020(class_6382 output) {
            output.method_37034(class_6381.field_33788, this.getNarration());
        }

        public abstract void render(class_332 var1, class_310 var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, float var11);

        public void renderBack(class_332 arg, class_310 client, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals(this.list.getEntryAtPosition(mouseX, mouseY), this);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return true;
        }
    }
}

