/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.integrations.logging.SLF4JLogger;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class NbtUtils {
    public static CompoundTag getNbt(Entity entity) {
        CompoundTag compoundTag;
        ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), ((SLF4JLogger)CoreUtils.LOG).getLogInstance());
        try {
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)entity.registryAccess());
            entity.saveWithoutId((ValueOutput)tagValueOutput);
            compoundTag = tagValueOutput.buildResult();
        }
        catch (Throwable throwable) {
            try {
                try {
                    scopedCollector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                return new CompoundTag();
            }
        }
        scopedCollector.close();
        return compoundTag;
    }

    public static CompoundTag getNbt(DataComponentHolder stack) {
        CompoundTag result = new CompoundTag();
        return stack != null ? ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag() : result;
    }

    public static Tag getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            Entity entity = (Entity)data;
            return NbtUtils.getNbt(entity, path);
        }
        if (data instanceof DataComponentHolder) {
            DataComponentHolder component = (DataComponentHolder)data;
            return NbtUtils.getNbt(component, path);
        }
        return null;
    }

    public static Tag getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static Tag getNbt(DataComponentHolder stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static Tag getNbt(CompoundTag root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        CompoundTag currentTag = root;
        for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof CompoundTag) {
                CompoundTag compound = currentTag;
                currentTag = compound.get(path[i]);
                continue;
            }
            if (currentTag instanceof ListTag) {
                ListTag list = (ListTag)currentTag;
                int index = Integer.parseInt(path[i]);
                currentTag = list.get(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getId()) {
            case 1: {
                return ((ByteTag)tag).byteValue();
            }
            case 2: {
                return ((ShortTag)tag).shortValue();
            }
            case 3: {
                return ((IntTag)tag).intValue();
            }
            case 4: {
                return ((LongTag)tag).longValue();
            }
            case 5: {
                return Float.valueOf(((FloatTag)tag).floatValue());
            }
            case 6: {
                return ((DoubleTag)tag).doubleValue();
            }
            case 7: {
                return ((ByteArrayTag)tag).getAsByteArray();
            }
            case 8: {
                return ((StringTag)tag).value();
            }
            case 9: {
                ListTag list = (ListTag)tag;
                List converted = StringUtils.newArrayList();
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        converted.add(NbtUtils.parseTag(list.get(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    return tag.toString();
                }
            }
            case 11: {
                return ((IntArrayTag)tag).getAsIntArray();
            }
            case 12: {
                return ((LongArrayTag)tag).getAsLongArray();
            }
        }
        return tag;
    }
}

