/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.widgets;

import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget$jvmdg$StaticDefaults;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextDisplayWidget;
import java.util.List;

public class ScrollableTextWidget
extends TextDisplayWidget {
    public ScrollableTextWidget(boolean centered, int startX, int startY, int width, String message) {
        super(centered, startX, startY, width, message);
    }

    public ScrollableTextWidget(int startX, int startY, int width, String message) {
        super(startX, startY, width, message);
    }

    public ScrollableTextWidget(boolean centered, int startX, int startY, int width) {
        super(centered, startX, startY, width);
    }

    public ScrollableTextWidget(int startX, int startY, int width) {
        super(startX, startY, width);
    }

    public ScrollableTextWidget(boolean centered, int width, String message) {
        super(centered, width, message);
    }

    public ScrollableTextWidget(int width, String message) {
        super(width, message);
    }

    public ScrollableTextWidget(boolean centered, int width) {
        super(centered, width);
    }

    public ScrollableTextWidget(int width) {
        super(width);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        int padding = 0;
        int barWidth = 0;
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        int minX = this.getControlPosX() + padding;
        int maxX = this.getRight() - padding - barWidth;
        int centerX = this.isCentered() ? maxX - (maxX - minX) / 2 : minX + screen.getStringWidth(this.getMessage()) / 2;
        screen.renderScrollingString(this.getMessage(), centerX, minX, this.getControlPosY() + padding, maxX, this.getBottom() - padding, 0xFFFFFF);
    }

    @Override
    public List<String> refreshContent(ExtendedScreen screen) {
        return null;
    }

    @Override
    public List<String> getRenderLines() {
        return null;
    }

    @Override
    public int getControlHeight() {
        return 20;
    }

    @Override
    public int getBottom() {
        return DynamicWidget$jvmdg$StaticDefaults.getBottom(this);
    }

    @Override
    public int getTop() {
        return DynamicWidget$jvmdg$StaticDefaults.getTop(this);
    }

    @Override
    public int getLeft() {
        return DynamicWidget$jvmdg$StaticDefaults.getLeft(this);
    }

    @Override
    public int getRight() {
        return DynamicWidget$jvmdg$StaticDefaults.getRight(this);
    }
}

