/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.integrations.logging;

import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;

public abstract class LoggingImpl {
    private final String loggerName;
    private boolean debugMode;

    public LoggingImpl(String loggerName, boolean debug) {
        this.loggerName = loggerName;
        this.debugMode = debug;
    }

    public LoggingImpl(String loggerName) {
        this(loggerName, false);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void error(String logMessage, Object ... logArguments) {
        throw new UnsupportedOperationException();
    }

    public void error(String logMessage, Throwable ex2) {
        this.error(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void error(Throwable ex2) {
        this.error(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void warn(String logMessage, Object ... logArguments) {
        throw new UnsupportedOperationException();
    }

    public void warn(String logMessage, Throwable ex2) {
        this.warn(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void warn(Throwable ex2) {
        this.warn(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void info(String logMessage, Object ... logArguments) {
        throw new UnsupportedOperationException();
    }

    public void info(String logMessage, Throwable ex2) {
        this.info(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void info(Throwable ex2) {
        this.info(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugInfo(String logMessage, Object ... logArguments) {
        if (this.isDebugMode()) {
            this.info("[DEBUG] " + logMessage, logArguments);
        }
    }

    public void debugInfo(String logMessage, Throwable ex2) {
        this.debugInfo(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugInfo(Throwable ex2) {
        this.debugInfo(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugWarn(String logMessage, Object ... logArguments) {
        if (this.isDebugMode()) {
            this.warn("[DEBUG] " + logMessage, logArguments);
        }
    }

    public void debugWarn(String logMessage, Throwable ex2) {
        this.debugWarn(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugWarn(Throwable ex2) {
        this.debugWarn(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugError(String logMessage, Object ... logArguments) {
        if (this.isDebugMode()) {
            this.error("[DEBUG] " + logMessage, logArguments);
        }
    }

    public void debugError(String logMessage, Throwable ex2) {
        this.debugError(logMessage + "\n" + StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public void debugError(Throwable ex2) {
        this.debugError(StringUtils.getStackTrace(ex2), new Object[0]);
    }

    public String getPrefix() {
        return "";
    }

    public String parse(String message, Object ... args) {
        return this.getPrefix() + StringUtils.normalize(String.format(message, args));
    }

    public void printStackTrace(Throwable ex2, boolean showLogging, String prefix, String verbosePrefix, Appendable ... outputs) {
        List<String> splitEx = StringUtils.splitTextByNewLine(StringUtils.getStackTrace(ex2));
        if (outputs != null) {
            for (Appendable output : outputs) {
                if (output == null) continue;
                try {
                    if (showLogging) {
                        for (String line : splitEx) {
                            line = line.replace("\t", "    ");
                            output.append(line).append('\n');
                        }
                        continue;
                    }
                    output.append(splitEx.get(0)).append('\n');
                    if (splitEx.size() <= 1) continue;
                    output.append('\n').append(verbosePrefix).append('\n');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (showLogging) {
            this.error(prefix, new Object[0]);
            this.error(ex2);
        } else {
            this.error("%1$s \"%2$s\"", prefix, splitEx.get(0));
            if (splitEx.size() > 1) {
                this.error(verbosePrefix, new Object[0]);
            }
        }
    }

    public void printStackTrace(Throwable ex2, String prefix, String verbosePrefix, Appendable ... outputs) {
        this.printStackTrace(ex2, this.isDebugMode(), prefix, verbosePrefix, outputs);
    }
}

