/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import io.github.cdagaming.unicore.UniCore;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import unilib.external.io.github.classgraph.ClassInfo;

public class MappingUtils {
    private static Map<String, String> classMap = null;
    private static String filePath = "/mappings.srg";

    public static boolean areMappingsLoaded() {
        return classMap != null;
    }

    public static void setFilePath(String filePath) {
        MappingUtils.filePath = filePath;
    }

    public static Map<String, String> getClassMap() {
        if (!MappingUtils.areMappingsLoaded()) {
            Map<String, String> cm2 = StringUtils.newHashMap();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getResourceAsStream(MappingUtils.class, filePath), StringUtils.DEFAULT_CHARSET));){
                UniCore.LOG.debugInfo("Loading Mappings...", new Object[0]);
                Instant time = TimeUtils.getCurrentTime();
                String line = reader.readLine();
                while (line != null) {
                    String[] parts = line.split(" ");
                    if (parts[0].equals("CL:")) {
                        cm2.put(parts[1], parts[2]);
                    }
                    line = reader.readLine();
                }
                UniCore.LOG.debugInfo("Loaded Mappings in " + TimeUtils.getDurationFrom(time).toMillis() + "ms", new Object[0]);
            }
            catch (Throwable ex2) {
                UniCore.LOG.debugError(ex2);
            }
            classMap = cm2;
        }
        return StringUtils.newHashMap(classMap);
    }

    public static String getMappedPath(String input) {
        if (MappingUtils.areMappingsLoaded() && classMap.containsKey(input)) {
            return classMap.get(input);
        }
        return input;
    }

    public static Set<String> getUnmappedClassesMatching(String start, BiPredicate<String, String> matchCondition) {
        Set<String> matches = StringUtils.newHashSet();
        if (MappingUtils.areMappingsLoaded()) {
            for (Map.Entry<String, String> entry : classMap.entrySet()) {
                if (!matchCondition.test(entry.getValue(), start)) continue;
                matches.add(entry.getKey());
            }
        }
        return matches;
    }

    public static Set<String> getUnmappedClassesMatching(String start, boolean exact) {
        return MappingUtils.getUnmappedClassesMatching(start, exact ? (BiPredicate<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;Ljava/lang/String;)Z)() : (BiPredicate<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Z)());
    }

    public static Set<String> getUnmappedClassesMatching(String start) {
        return MappingUtils.getUnmappedClassesMatching(start, false);
    }

    public static String getClassName(ClassInfo object, boolean simpleName) {
        return MappingUtils.getClassName(simpleName, object.getName(), object.getSimpleName());
    }

    public static String getClassName(Class<?> object, boolean simpleName) {
        return MappingUtils.getClassName(simpleName, object.getName(), object.getSimpleName());
    }

    private static String getClassName(boolean simpleName, String primary, String secondary) {
        String result;
        String string = result = MappingUtils.areMappingsLoaded() ? classMap.get(primary) : null;
        result = result == null ? (simpleName ? secondary : primary) : (simpleName ? result.substring(result.lastIndexOf(".") + 1) : result);
        return result;
    }

    public static String getCanonicalName(ClassInfo object) {
        return MappingUtils.getClassName(object, false);
    }

    public static String getCanonicalName(Class<?> object) {
        return MappingUtils.getClassName(object, false);
    }

    public static String getCanonicalName(Object object) {
        return MappingUtils.getCanonicalName(object.getClass());
    }

    public static String getClassName(ClassInfo object) {
        return MappingUtils.getClassName(object, true);
    }

    public static String getClassName(Class<?> object) {
        return MappingUtils.getClassName(object, true);
    }

    public static String getClassName(Object object) {
        return MappingUtils.getClassName(object.getClass());
    }
}

