/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core;

import com.gitlab.cdagaming.unilib.core.integrations.logging.LegacyLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CoreUtils {
    public static final String NAME = "UniLib";
    public static final String VERSION_ID = "v1.2.0";
    public static final String VERSION_TYPE = "Release";
    public static final String MOD_ID = "unilib";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/UniLib/update.json";
    public static final String MCBuildVersion = "1.1";
    public static final int MCBuildProtocol = StringUtils.getValidInteger("23").getSecond();
    public static final String modsDir = CoreUtils.jvmdowngrader$concat$$clinit$$1(OSUtils.USER_DIR, File.separator);
    public static final boolean IS_LEGACY_SOFT = StringUtils.getValidBoolean("true").getSecond();
    public static final LegacyLogger LOG = new LegacyLogger("unilib");
    private static final Function<Integer, Boolean> IS_LEGACY_HARD_SUPPLIER = (Function<Integer, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$0(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/Boolean;)();
    private static final boolean IS_LEGACY_HARD = CoreUtils.isLegacyHard(MCBuildProtocol);
    private static final Function<Integer, Boolean> IS_LEGACY_ALPHA_SUPPLIER = (Function<Integer, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$1(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/Boolean;)();
    private static final boolean IS_LEGACY_ALPHA = CoreUtils.isLegacyAlpha(MCBuildProtocol);
    private static final Function<Integer, Boolean> IS_TEXT_FORMATTING_BLOCKED_SUPPLIER = (Function<Integer, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$2(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/Boolean;)();
    private static final boolean IS_TEXT_FORMATTING_BLOCKED = CoreUtils.isTextFormattingBlocked(MCBuildProtocol);
    private static final Function<Integer, String> DEFAULT_LANGUAGE_SUPPLIER = (Function<Integer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$3(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/String;)();
    private static final String DEFAULT_LANGUAGE = CoreUtils.getDefaultLanguage(MCBuildProtocol);
    private static final Map<String, Runnable> onTickEvents = StringUtils.newConcurrentHashMap();
    public static boolean IS_CLOSING = false;
    public static Supplier<Integer> MOD_COUNT_SUPPLIER = null;
    private static int DETECTED_MOD_COUNT = -1;

    public static void registerTickEvent(String id, Runnable event) {
        if (!onTickEvents.containsKey(id)) {
            onTickEvents.put(id, event);
        }
    }

    public static void registerTickEvent(Runnable event) {
        CoreUtils.registerTickEvent(MOD_ID, event);
    }

    public static void scheduleTickEvent(String name, Runnable event) {
        if (!IS_CLOSING) {
            FileUtils.getThreadPool(name).scheduleAtFixedRate(event, 0L, 50L, TimeUtils.getTimeUnitFrom("MILLISECONDS"));
        }
    }

    public static void scheduleTickEvent(Runnable event) {
        CoreUtils.scheduleTickEvent(NAME, event);
    }

    public static void setup() {
        Runtime.getRuntime().addShutdownHook(CoreUtils.getThreadFactory().newThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$setup$4(), ()V)()));
        CoreUtils.scheduleTickEvent((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$setup$5(), ()V)());
    }

    public static ScheduledExecutorService getThreadPool() {
        return FileUtils.getThreadPool(NAME);
    }

    public static ThreadFactory getThreadFactory() {
        return FileUtils.getThreadFactory(NAME);
    }

    public static boolean isLegacyHard(int protocol) {
        return IS_LEGACY_HARD_SUPPLIER.apply(protocol);
    }

    public static boolean isLegacyHard() {
        return IS_LEGACY_HARD;
    }

    public static boolean isLegacyAlpha(int protocol) {
        return IS_LEGACY_ALPHA_SUPPLIER.apply(protocol);
    }

    public static boolean isLegacyAlpha() {
        return IS_LEGACY_ALPHA;
    }

    public static boolean isTextFormattingBlocked(int protocol) {
        return IS_TEXT_FORMATTING_BLOCKED_SUPPLIER.apply(protocol);
    }

    public static boolean isTextFormattingBlocked() {
        return IS_TEXT_FORMATTING_BLOCKED;
    }

    public static String getDefaultLanguage(int protocol) {
        return DEFAULT_LANGUAGE_SUPPLIER.apply(protocol);
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public static String findGameBrand(String fallback) {
        String result = null;
        try {
            result = CoreUtils.jvmdg$inlined$getProperty("minecraft.launcher.brand");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StringUtils.getOrDefault(result, fallback);
    }

    public static TranslationUtils findGameTranslations(int protocol) {
        boolean hasVanillaTranslations;
        boolean bl = hasVanillaTranslations = !IS_LEGACY_SOFT || protocol >= 7;
        return hasVanillaTranslations ? new TranslationUtils("minecraft", !IS_LEGACY_SOFT && protocol >= 353).setUsingAssetsPath(!IS_LEGACY_SOFT || protocol >= 72).setDefaultLanguage(CoreUtils.getDefaultLanguage(protocol)).setStripFormatting(CoreUtils.isTextFormattingBlocked(protocol)).build() : null;
    }

    public static int getModCount() {
        if (DETECTED_MOD_COUNT <= 0) {
            DETECTED_MOD_COUNT = MOD_COUNT_SUPPLIER != null ? MOD_COUNT_SUPPLIER.get() : CoreUtils.getRawModCount();
        }
        return DETECTED_MOD_COUNT;
    }

    private static int getRawModCount() {
        int modCount = 0;
        File[] mods = new File(modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return Math.max(1, modCount);
    }

    private static /* synthetic */ void lambda$setup$5() {
        for (Runnable event : onTickEvents.values()) {
            try {
                event.run();
            }
            catch (Throwable ex) {
                LOG.error(ex);
            }
        }
    }

    private static /* synthetic */ void lambda$setup$4() {
        IS_CLOSING = true;
        FileUtils.shutdownSchedulers();
    }

    private static /* synthetic */ String lambda$static$3(Integer protocol) {
        return protocol >= 315 ? "en_us" : "en_US";
    }

    private static /* synthetic */ Boolean lambda$static$2(Integer protocol) {
        return IS_LEGACY_SOFT && protocol <= 23;
    }

    private static /* synthetic */ Boolean lambda$static$1(Integer protocol) {
        return IS_LEGACY_SOFT && protocol <= 2;
    }

    private static /* synthetic */ Boolean lambda$static$0(Integer protocol) {
        return IS_LEGACY_SOFT && protocol <= 61;
    }

    private static String jvmdowngrader$concat$$clinit$$1(String string, String string2) {
        return string + string2 + "mods";
    }

    @Stub(ref=@Ref(value="java/lang/System"))
    private static String jvmdg$inlined$getProperty(String key) {
        if (key.equals("native.encoding")) {
            String prop = System.getProperty(key);
            if (prop != null) {
                return prop;
            }
            return System.getProperty("file.encoding");
        }
        return System.getProperty(key);
    }
}

