/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl.screen;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={ColorSection.class, ColorData.class, TooltipData.class})
public class ScreenConstants {
    public static final ColorData DEFAULT_TOOLTIP_BACKGROUND = new ColorData(new ColorSection(16, 0, 16, 240));
    public static final ColorData DEFAULT_TOOLTIP_BORDER = new ColorData(new ColorSection(80, 0, 255, 80), new ColorSection(40, 0, 127, 80));
    public static final ColorData DEFAULT_ALT_SCREEN_BACKGROUND = new ColorData(new ColorSection(16, 16, 16, 192), new ColorSection(16, 16, 16, 208));
    private static final Function<Integer, String> DEFAULT_BUTTON_BACKGROUND_SUPPLIER = (Function<Integer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$0(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/String;)();
    private static final String DEFAULT_BUTTON_BACKGROUND = ScreenConstants.getDefaultButtonBackground(CoreUtils.MCBuildProtocol);
    private static final Function<Integer, String> DEFAULT_GUI_BACKGROUND_SUPPLIER = (Function<Integer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$1(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/String;)();
    private static final String DEFAULT_GUI_BACKGROUND = ScreenConstants.getDefaultGUIBackground(CoreUtils.MCBuildProtocol);
    public static final ColorData DEFAULT_SCREEN_BACKGROUND = new ColorData(new ColorSection(64, 64, 64, 255), ScreenConstants.getDefaultGUIBackground());
    private static final TooltipData DEFAULT_TOOLTIP = new TooltipData(true, DEFAULT_TOOLTIP_BACKGROUND, DEFAULT_TOOLTIP_BORDER);
    private static final TooltipData EMPTY_TOOLTIP = new TooltipData(true, null, null);

    public static String getDefaultButtonBackground(int protocol) {
        return DEFAULT_BUTTON_BACKGROUND_SUPPLIER.apply(protocol);
    }

    public static String getDefaultButtonBackground() {
        return DEFAULT_BUTTON_BACKGROUND;
    }

    public static String getDefaultGUIBackground(int protocol) {
        return DEFAULT_GUI_BACKGROUND_SUPPLIER.apply(protocol);
    }

    public static String getDefaultGUIBackground() {
        return DEFAULT_GUI_BACKGROUND;
    }

    public static TooltipData getEmptyTooltip() {
        return EMPTY_TOOLTIP;
    }

    public static TooltipData getDefaultTooltip() {
        return DEFAULT_TOOLTIP;
    }

    private static /* synthetic */ String lambda$static$1(Integer protocol) {
        return ScreenConstants.jvmdowngrader$concat$lambda$static$1$1(CoreUtils.isLegacyHard(protocol) ? (CoreUtils.isLegacyAlpha(protocol) ? "/dirt.png" : "/gui/background.png") : "textures/gui/options_background.png");
    }

    private static /* synthetic */ String lambda$static$0(Integer protocol) {
        return ScreenConstants.jvmdowngrader$concat$lambda$static$1$1(CoreUtils.isLegacyHard(protocol) ? "/gui/gui.png" : "textures/gui/widgets.png");
    }

    private static String jvmdowngrader$concat$lambda$static$1$1(String string) {
        return "minecraft:" + string;
    }

    @RecordComponents(value={@RecordComponents.Value(name="renderTooltips", type=boolean.class), @RecordComponents.Value(name="backgroundColor", type=ColorData.class), @RecordComponents.Value(name="borderColor", type=ColorData.class)})
    @NestHost(value=ScreenConstants.class)
    public static final class TooltipData
    extends J_L_Record {
        private final boolean renderTooltips;
        private final ColorData backgroundColor;
        private final ColorData borderColor;

        public TooltipData(boolean renderTooltips, ColorData backgroundColor, ColorData borderColor) {
            this.renderTooltips = renderTooltips;
            this.backgroundColor = backgroundColor;
            this.borderColor = borderColor;
        }

        @Override
        public final String toString() {
            return TooltipData.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return TooltipData.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return TooltipData.jvmdowngrader$equals$equals(this, o);
        }

        public boolean renderTooltips() {
            return this.renderTooltips;
        }

        public ColorData backgroundColor() {
            return this.backgroundColor;
        }

        public ColorData borderColor() {
            return this.borderColor;
        }

        private static String jvmdowngrader$toString$toString(TooltipData tooltipData) {
            TooltipData tooltipData2 = tooltipData;
            return "ScreenConstants$TooltipData[" + "renderTooltips=" + tooltipData.renderTooltips + ", " + "backgroundColor=" + tooltipData.backgroundColor + ", " + "borderColor=" + tooltipData.borderColor + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(TooltipData tooltipData) {
            Object[] objectArray = new Object[]{tooltipData.renderTooltips, tooltipData.backgroundColor, tooltipData.borderColor};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(TooltipData tooltipData, Object object) {
            if (tooltipData == object) {
                return true;
            }
            if (object != null && object instanceof TooltipData) {
                TooltipData tooltipData2 = (TooltipData)object;
                if (tooltipData.renderTooltips == tooltipData2.renderTooltips && Objects.equals(tooltipData.backgroundColor, tooltipData2.backgroundColor) && Objects.equals(tooltipData.borderColor, tooltipData2.borderColor)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="start", type=ColorSection.class), @RecordComponents.Value(name="end", type=ColorSection.class), @RecordComponents.Value(name="texLocation", type=String.class), @RecordComponents.Value(name="texLevel", type=double.class), @RecordComponents.Value(name="colorLevel", type=double.class), @RecordComponents.Value(name="useFullTexture", type=boolean.class), @RecordComponents.Value(name="textureWidth", type=double.class), @RecordComponents.Value(name="textureHeight", type=double.class)})
    @NestHost(value=ScreenConstants.class)
    public static final class ColorData
    extends J_L_Record {
        private final ColorSection start;
        private final ColorSection end;
        private final String texLocation;
        private final double texLevel;
        private final double colorLevel;
        private final boolean useFullTexture;
        private final double textureWidth;
        private final double textureHeight;

        public ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, end, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel) {
            this(start, end, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(ColorSection start, ColorSection end, String texLocation) {
            this(start, end, texLocation, 0.0, 300.0);
        }

        public ColorData(ColorSection start, ColorSection end) {
            this(start, end, "");
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(start, null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel) {
            this(start, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(ColorSection start, String texLocation) {
            this(start, texLocation, 0.0, 300.0);
        }

        public ColorData(ColorSection start) {
            this(start, "");
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(new ColorSection(start), end != null ? new ColorSection(end) : null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, end, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel) {
            this(start, end, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(Color start, Color end, String texLocation) {
            this(start, end, texLocation, 0.0, 300.0);
        }

        public ColorData(Color start, Color end) {
            this(start, end, "");
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(start, null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel) {
            this(start, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(Color start, String texLocation) {
            this(start, texLocation, 0.0, 300.0);
        }

        public ColorData(Color start) {
            this(start, "");
        }

        public ColorData(String texLocation, double texLevel, double textureWidth, double textureHeight) {
            this(new ColorSection(), texLocation, texLevel, 300.0, true, textureWidth, textureHeight);
        }

        public ColorData(String texLocation, double texLevel) {
            this(texLocation, texLevel, 32.0, 32.0);
        }

        public ColorData(String texLocation) {
            this(texLocation, 0.0);
        }

        public ColorData() {
            this("");
        }

        public ColorData(ColorData other) {
            this(other.start, other.end, other.texLocation);
        }

        public ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this.start = start;
            this.end = end;
            this.texLocation = texLocation;
            this.texLevel = texLevel;
            this.colorLevel = colorLevel;
            this.useFullTexture = useFullTexture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        public boolean hasEnd() {
            return this.end != null;
        }

        public ColorSection end() {
            return this.hasEnd() ? this.end : this.start();
        }

        public Color startColor() {
            return this.start().color();
        }

        public Color endColor() {
            return this.end().color();
        }

        public boolean hasTexLocation() {
            return !StringUtils.isNullOrEmpty(this.texLocation);
        }

        public String texLocation() {
            return this.hasTexLocation() ? this.texLocation : "";
        }

        @Override
        public final String toString() {
            return ColorData.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ColorData.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ColorData.jvmdowngrader$equals$equals(this, o);
        }

        public ColorSection start() {
            return this.start;
        }

        public double texLevel() {
            return this.texLevel;
        }

        public double colorLevel() {
            return this.colorLevel;
        }

        public boolean useFullTexture() {
            return this.useFullTexture;
        }

        public double textureWidth() {
            return this.textureWidth;
        }

        public double textureHeight() {
            return this.textureHeight;
        }

        private static String jvmdowngrader$toString$toString(ColorData colorData) {
            ColorData colorData2 = colorData;
            return "ScreenConstants$ColorData[" + "start=" + colorData.start + ", " + "end=" + colorData.end + ", " + "texLocation=" + colorData.texLocation + ", " + "texLevel=" + colorData.texLevel + ", " + "colorLevel=" + colorData.colorLevel + ", " + "useFullTexture=" + colorData.useFullTexture + ", " + "textureWidth=" + colorData.textureWidth + ", " + "textureHeight=" + colorData.textureHeight + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ColorData colorData) {
            Object[] objectArray = new Object[]{colorData.start, colorData.end, colorData.texLocation, colorData.texLevel, colorData.colorLevel, colorData.useFullTexture, colorData.textureWidth, colorData.textureHeight};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ColorData colorData, Object object) {
            if (colorData == object) {
                return true;
            }
            if (object != null && object instanceof ColorData) {
                ColorData colorData2 = (ColorData)object;
                if (Objects.equals(colorData.start, colorData2.start) && Objects.equals(colorData.end, colorData2.end) && Objects.equals(colorData.texLocation, colorData2.texLocation) && colorData.texLevel == colorData2.texLevel && colorData.colorLevel == colorData2.colorLevel && colorData.useFullTexture == colorData2.useFullTexture && colorData.textureWidth == colorData2.textureWidth && colorData.textureHeight == colorData2.textureHeight) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="red", type=int.class), @RecordComponents.Value(name="green", type=int.class), @RecordComponents.Value(name="blue", type=int.class), @RecordComponents.Value(name="alpha", type=int.class)})
    @NestHost(value=ScreenConstants.class)
    public static final class ColorSection
    extends J_L_Record {
        private final int red;
        private final int green;
        private final int blue;
        private final int alpha;

        public ColorSection(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }

        public ColorSection(ColorSection other) {
            this(other.red, other.green, other.blue, other.alpha);
        }

        public ColorSection() {
            this(Color.white);
        }

        public ColorSection(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public Color color() {
            return StringUtils.getColorFrom(this.red(), this.green(), this.blue(), this.alpha());
        }

        @Override
        public final String toString() {
            return ColorSection.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ColorSection.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ColorSection.jvmdowngrader$equals$equals(this, o);
        }

        public int red() {
            return this.red;
        }

        public int green() {
            return this.green;
        }

        public int blue() {
            return this.blue;
        }

        public int alpha() {
            return this.alpha;
        }

        private static String jvmdowngrader$toString$toString(ColorSection colorSection) {
            ColorSection colorSection2 = colorSection;
            return "ScreenConstants$ColorSection[" + "red=" + colorSection.red + ", " + "green=" + colorSection.green + ", " + "blue=" + colorSection.blue + ", " + "alpha=" + colorSection.alpha + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ColorSection colorSection) {
            Object[] objectArray = new Object[]{colorSection.red, colorSection.green, colorSection.blue, colorSection.alpha};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ColorSection colorSection, Object object) {
            if (colorSection == object) {
                return true;
            }
            if (object != null && object instanceof ColorSection) {
                ColorSection colorSection2 = (ColorSection)object;
                if (colorSection.red == colorSection2.red && colorSection.green == colorSection2.green && colorSection.blue == colorSection2.blue && colorSection.alpha == colorSection2.alpha) {
                    return true;
                }
            }
            return false;
        }
    }
}

