/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.Identifier;

public class ResourceUtils {
    private static final Identifier EMPTY_RESOURCE = ResourceUtils.parseResource("");
    private static final Map<String, Integer> prefixRegister = StringUtils.newHashMap();

    public static Identifier getResource(String namespace, String path) {
        return Identifier.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static Identifier getResource(String path) {
        return ResourceUtils.getResource("minecraft", path);
    }

    public static Identifier parseResource(String path) {
        return Identifier.parse((String)path);
    }

    public static Identifier getEmptyResource() {
        return EMPTY_RESOURCE;
    }

    public static String getNamespace(Identifier location) {
        return location != null ? location.getNamespace() : "";
    }

    public static String getPath(Identifier location) {
        return location != null ? location.getPath() : "";
    }

    public static boolean isValidResource(Identifier location) {
        return location != null && !StringUtils.isNullOrEmpty(ResourceUtils.getNamespace(location)) && !StringUtils.isNullOrEmpty(ResourceUtils.getPath(location));
    }

    public static Identifier register(TextureManager manager, String prefix, DynamicTexture dynamicTexture) {
        Integer index = prefixRegister.get(prefix);
        index = index == null ? Integer.valueOf(1) : Integer.valueOf(index + 1);
        prefixRegister.put(prefix, index);
        Identifier resourceLocation = Identifier.withDefaultNamespace((String)String.format(Locale.ROOT, "dynamic/%s_%d", prefix, index));
        manager.register(resourceLocation, (AbstractTexture)dynamicTexture);
        return resourceLocation;
    }
}

