/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl.screen;

import javax.annotation.Nullable;

public record ScreenRectangle(int posX, int posY, int width, int height) {
    private static final ScreenRectangle EMPTY = new ScreenRectangle(0, 0, 0, 0);

    public static ScreenRectangle empty() {
        return EMPTY;
    }

    @Nullable
    public ScreenRectangle intersection(ScreenRectangle rectangle) {
        int i = Math.max(this.getLeft(), rectangle.getLeft());
        int j = Math.max(this.getTop(), rectangle.getTop());
        int k = Math.min(this.getRight(), rectangle.getRight());
        int l = Math.min(this.getBottom(), rectangle.getBottom());
        return i < k && j < l ? new ScreenRectangle(i, j, k - i, l - j) : null;
    }

    public int getTop() {
        return this.posY();
    }

    public int getBottom() {
        return this.posY() + this.height();
    }

    public int getLeft() {
        return this.posX();
    }

    public int getRight() {
        return this.posX() + this.width();
    }
}

