/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.Language;
import net.minecraft.core.lang.LanguageSeeker;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="client", type=Minecraft.class), @RecordComponents.Value(name="instance", type=TranslationUtils.class)})
public final class TranslationManager
extends J_L_Record {
    private final Minecraft client;
    private final TranslationUtils instance;

    public TranslationManager(Minecraft client, TranslationUtils instance) {
        this.client = client;
        this.instance = instance;
        this.instance().setOnLanguageSync((Consumer<Map<String, String>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$0(java.util.Map ), (Ljava/util/Map;)V)());
        this.instance().setResourceSupplier((BiFunction<TranslationUtils, String, List<InputStream>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$1(io.github.cdagaming.unicore.utils.TranslationUtils java.lang.String ), (Lio/github/cdagaming/unicore/utils/TranslationUtils;Ljava/lang/String;)Ljava/util/List;)());
    }

    public void onTick() {
        this.instance().onTick();
    }

    public void onReload() {
        this.instance().syncTranslations();
    }

    @Override
    public final String toString() {
        return TranslationManager.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return TranslationManager.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return TranslationManager.jvmdowngrader$equals$equals(this, o);
    }

    public Minecraft client() {
        return this.client;
    }

    public TranslationUtils instance() {
        return this.instance;
    }

    private static /* synthetic */ List lambda$new$1(TranslationUtils data, String langPath) {
        File[] files;
        File LANGUAGE_DIR;
        String modId = data.getModId();
        String assetsPath = data.getAssetsPath();
        List results = StringUtils.newArrayList();
        String fullPath = TranslationManager.jvmdowngrader$concat$lambda$new$1$1(assetsPath, langPath);
        String fileExt = FileUtils.getFileExtension(fullPath);
        String id = FileUtils.getFileNameWithoutExtension(fullPath.substring(fullPath.lastIndexOf("/") + 1));
        String filePath = FileUtils.getFileNameWithoutExtension(fullPath);
        if (!modId.equals("minecraft") && assetsPath.equals("/")) {
            filePath = filePath.replace("/lang", TranslationManager.jvmdowngrader$concat$lambda$new$1$1(modId));
        }
        for (String path : FileUtils.filesInDir(TranslationUtils.class, filePath)) {
            if (!path.endsWith(fileExt)) continue;
            try {
                InputStream stream = FileUtils.getResourceAsStream(TranslationUtils.class, path);
                if (stream == null) continue;
                results.add(stream);
            }
            catch (Exception exception) {}
        }
        if (fileExt.equals(".lang") && (LANGUAGE_DIR = LanguageSeeker.LANGUAGE_DIR).exists() && LANGUAGE_DIR.isDirectory() && (files = LANGUAGE_DIR.listFiles()) != null) {
            for (File file : files) {
                try {
                    if (!file.getName().endsWith(".zip")) continue;
                    ZipFile zip = new ZipFile(file);
                    InputStream stream = zip.getInputStream(zip.getEntry("lang_info.json"));
                    String content = FileUtils.fileToString(stream, "UTF-8");
                    JsonObject json = FileUtils.parseJson(content).getAsJsonObject();
                    String langId = json.getAsJsonPrimitive("id").getAsString();
                    String langName = json.getAsJsonPrimitive("name").getAsString();
                    List langCredits = StringUtils.newArrayList();
                    for (JsonElement element : json.getAsJsonArray("credits")) {
                        String string = element.getAsString();
                        if (string == null) continue;
                        langCredits.add(string);
                    }
                    if (langId != null && langName != null && !langCredits.isEmpty() && langId.equals(id)) {
                        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
                        while (zipEntries.hasMoreElements()) {
                            InputStream langStream;
                            ZipEntry entry = zipEntries.nextElement();
                            if (!entry.getName().endsWith(fileExt) || (langStream = zip.getInputStream(entry)) == null) continue;
                            String langContent = FileUtils.fileToString(langStream, "UTF-8");
                            langStream = FileUtils.stringToStream(langContent, "UTF-8");
                            results.add(langStream);
                        }
                    }
                    zip.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return results;
    }

    private static /* synthetic */ void lambda$new$0(Map entries) {
        Language language = I18n.getInstance().getCurrentLanguage();
        Properties data = (Properties)StringUtils.getField(Language.class, language, "entries");
        data.putAll((Map<?, ?>)entries);
        StringUtils.updateField(Language.class, language, data, "entries");
    }

    private static String jvmdowngrader$toString$toString(TranslationManager translationManager) {
        TranslationManager translationManager2 = translationManager;
        return "TranslationManager[" + "client=" + translationManager.client + ", " + "instance=" + translationManager.instance + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(TranslationManager translationManager) {
        Object[] objectArray = new Object[]{translationManager.client, translationManager.instance};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(TranslationManager translationManager, Object object) {
        if (translationManager == object) {
            return true;
        }
        if (object != null && object instanceof TranslationManager) {
            TranslationManager translationManager2 = (TranslationManager)object;
            if (Objects.equals(translationManager.client, translationManager2.client) && Objects.equals(translationManager.instance, translationManager2.instance)) {
                return true;
            }
        }
        return false;
    }

    private static String jvmdowngrader$concat$lambda$new$1$1(String string, String string2) {
        return string + string2;
    }

    private static String jvmdowngrader$concat$lambda$new$1$1(String string) {
        return "/lang/" + string;
    }
}

