/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.net.lenni0451.reflect.stream.constructor;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import unilib.external.net.lenni0451.reflect.Constructors;
import unilib.external.net.lenni0451.reflect.exceptions.ConstructorNotFoundException;
import unilib.external.net.lenni0451.reflect.stream.RStream;
import unilib.external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper;

public class ConstructorStream {
    private final RStream parent;
    private final List<ConstructorWrapper> constructors;

    public ConstructorStream(RStream parent) {
        this.parent = parent;
        this.constructors = new ArrayList<ConstructorWrapper>();
        for (Constructor<?> constructor : Constructors.getDeclaredConstructors(parent.clazz())) {
            this.constructors.add(new ConstructorWrapper(this, constructor));
        }
    }

    private ConstructorStream(RStream parent, List<ConstructorWrapper> constructors) {
        this.parent = parent;
        this.constructors = constructors;
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.constructors.size();
    }

    public Optional<ConstructorWrapper> opt(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (ConstructorWrapper constructor : this.constructors) {
                if (constructor.parameterTypes().length != 0) continue;
                return Optional.of(constructor);
            }
        } else {
            for (ConstructorWrapper constructor : this.constructors) {
                if (!Arrays.equals(constructor.parameterTypes(), parameterTypes)) continue;
                return Optional.of(constructor);
            }
        }
        return Optional.empty();
    }

    public Optional<ConstructorWrapper> opt(int index) {
        if (index < 0 || index > this.constructors.size()) {
            return Optional.empty();
        }
        return Optional.of(this.constructors.get(index));
    }

    public ConstructorWrapper by(Class<?> ... parameterTypes) {
        return this.opt(parameterTypes).orElseThrow((Supplier<ConstructorNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$0(java.lang.Class[] ), ()Lunilib/external/net/lenni0451/reflect/exceptions/ConstructorNotFoundException;)((ConstructorStream)this, (Class[])parameterTypes));
    }

    public ConstructorWrapper by(int index) {
        return this.opt(index).orElseThrow((Supplier<ConstructorNotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$by$1(int ), ()Lunilib/external/net/lenni0451/reflect/exceptions/ConstructorNotFoundException;)((ConstructorStream)this, (int)index));
    }

    public ConstructorStream filter(Predicate<ConstructorWrapper> filter) {
        this.constructors.removeIf(filter.negate());
        return this;
    }

    public ConstructorStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((Predicate<ConstructorWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$2(unilib.external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper ), (Lunilib/external/net/lenni0451/reflect/stream/constructor/ConstructorWrapper;)Z)());
        }
        return this.filter((Predicate<ConstructorWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$3(java.lang.Class[] unilib.external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper ), (Lunilib/external/net/lenni0451/reflect/stream/constructor/ConstructorWrapper;)Z)((Class[])parameterTypes));
    }

    public ConstructorStream filter(boolean isStatic) {
        return this.filter((Predicate<ConstructorWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filter$4(boolean unilib.external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper ), (Lunilib/external/net/lenni0451/reflect/stream/constructor/ConstructorWrapper;)Z)((boolean)isStatic));
    }

    public ConstructorStream filterAnnotation(Class<?> annotation) {
        return this.filter((Predicate<ConstructorWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filterAnnotation$6(java.lang.Class unilib.external.net.lenni0451.reflect.stream.constructor.ConstructorWrapper ), (Lunilib/external/net/lenni0451/reflect/stream/constructor/ConstructorWrapper;)Z)(annotation));
    }

    public Iterator<ConstructorWrapper> iterator() {
        return this.constructors.iterator();
    }

    public <T> Stream<T> map(Function<ConstructorWrapper, T> mapFunction) {
        return this.jstream().map(mapFunction);
    }

    public Stream<ConstructorWrapper> jstream() {
        return this.constructors.stream();
    }

    public ConstructorStream forEach(Consumer<ConstructorWrapper> consumer) {
        this.constructors.forEach(consumer);
        return this;
    }

    public ConstructorStream copy() {
        return new ConstructorStream(this.parent, new ArrayList<ConstructorWrapper>(this.constructors));
    }

    private static /* synthetic */ boolean lambda$filterAnnotation$6(Class annotation, ConstructorWrapper constructor) {
        return constructor.annotations().anyMatch((Predicate<Annotation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$5(java.lang.Class java.lang.annotation.Annotation ), (Ljava/lang/annotation/Annotation;)Z)((Class)annotation));
    }

    private static /* synthetic */ boolean lambda$null$5(Class annotation, Annotation a) {
        return a.annotationType().equals(annotation);
    }

    private static /* synthetic */ boolean lambda$filter$4(boolean isStatic, ConstructorWrapper constructor) {
        return constructor.modifier().isStatic() == isStatic;
    }

    private static /* synthetic */ boolean lambda$filter$3(Class[] parameterTypes, ConstructorWrapper constructor) {
        return Arrays.equals(constructor.parameterTypes(), parameterTypes);
    }

    private static /* synthetic */ boolean lambda$filter$2(ConstructorWrapper constructor) {
        return constructor.parameterCount() == 0;
    }

    private /* synthetic */ ConstructorNotFoundException lambda$by$1(int index) {
        return new ConstructorNotFoundException(this.parent.clazz().getName(), String.valueOf(index));
    }

    private /* synthetic */ ConstructorNotFoundException lambda$by$0(Class[] parameterTypes) {
        return new ConstructorNotFoundException(this.parent.clazz().getName(), parameterTypes);
    }
}

