/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.image;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import unilib.external.com.twelvemonkeys.image.BufferedImageIcon;
import unilib.external.com.twelvemonkeys.image.ImageUtil;

public class AreaAverageOp
implements BufferedImageOp,
RasterOp {
    private final int width;
    private final int height;
    private Rectangle sourceRegion;

    public AreaAverageOp(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public Rectangle getSourceRegion() {
        if (this.sourceRegion == null) {
            return null;
        }
        return new Rectangle(this.sourceRegion);
    }

    public void setSourceRegion(Rectangle rectangle) {
        if (rectangle == null) {
            this.sourceRegion = null;
        } else if (this.sourceRegion == null) {
            this.sourceRegion = new Rectangle(rectangle);
        } else {
            this.sourceRegion.setBounds(rectangle);
        }
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3 = bufferedImage2 != null ? bufferedImage2 : this.createCompatibleDestImage(bufferedImage, null);
        long l = System.currentTimeMillis();
        this.filterImpl(bufferedImage.getRaster(), bufferedImage3.getRaster());
        long l2 = System.currentTimeMillis() - l;
        System.out.println("time: " + l2);
        return bufferedImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resample(BufferedImage bufferedImage, BufferedImage bufferedImage2, AffineTransform affineTransform) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            graphics2D.drawImage(bufferedImage, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster != null ? writableRaster : this.createCompatibleDestRaster(raster);
        return this.filterImpl(raster, writableRaster2);
    }

    private WritableRaster filterImpl(Raster raster, WritableRaster writableRaster) {
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.sourceRegion != null) {
            n5 = this.sourceRegion.x;
            n4 = this.sourceRegion.y;
            n3 = this.sourceRegion.width;
            n2 = this.sourceRegion.height;
            bl = raster == writableRaster;
            writableRaster = writableRaster.createWritableChild(n5, n4, n3, n2, 0, 0, null);
            raster = bl ? writableRaster : raster.createChild(n5, n4, n3, n2, 0, 0, null);
        }
        n5 = raster.getWidth();
        n4 = raster.getHeight();
        n3 = (n5 + this.width - 1) / this.width;
        n2 = (n4 + this.height - 1) / this.height;
        bl = n5 % this.width != 0;
        boolean bl2 = n4 % this.height != 0;
        int n6 = raster.getNumDataElements();
        int n7 = raster.getNumBands();
        int n8 = raster.getTransferType();
        Object object = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (raster.getTransferType() == 1) {
            if (raster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
                nArray = singlePixelPackedSampleModel.getBitMasks();
                nArray2 = singlePixelPackedSampleModel.getBitOffsets();
            } else {
                nArray = new int[]{65535};
                nArray2 = new int[]{0};
            }
        }
        for (int i = 0; i < this.height; ++i) {
            int n9 = !bl2 || i < this.height ? n2 : n4 - i * n2;
            for (int k = 0; k < this.width; ++k) {
                int n10 = !bl || k < this.width ? n3 : n5 - k * n3;
                int n11 = n10 * n9;
                int n12 = n11 * n6;
                try {
                    object = raster.getDataElements(k * n3, i * n2, n10, n9, object);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                switch (n8) {
                    case 0: {
                        byte[] byArray = (byte[])object;
                        for (int i2 = 0; i2 < n12; i2 += n6) {
                            d += (double)(byArray[i2] & 0xFF);
                            if (n7 <= 1) continue;
                            d2 += (double)(byArray[i2 + 1] & 0xFF);
                            d3 += (double)(byArray[i2 + 2] & 0xFF);
                            if (n7 <= 3) continue;
                            d4 += (double)(byArray[i2 + 3] & 0xFF);
                        }
                        d /= (double)n11;
                        if (n7 > 1) {
                            d2 /= (double)n11;
                            d3 /= (double)n11;
                            if (n7 > 3) {
                                d4 /= (double)n11;
                            }
                        }
                        byArray[0] = (byte)AreaAverageOp.clamp((int)d);
                        if (n7 <= 1) break;
                        byArray[1] = (byte)AreaAverageOp.clamp((int)d2);
                        byArray[2] = (byte)AreaAverageOp.clamp((int)d3);
                        if (n7 <= 3) break;
                        byArray[3] = (byte)AreaAverageOp.clamp((int)d4);
                        break;
                    }
                    case 3: {
                        int[] nArray3 = (int[])object;
                        for (int i3 = 0; i3 < n12; i3 += n6) {
                            d += (double)((nArray3[i3] & 0xFF000000) >> 24);
                            d2 += (double)((nArray3[i3] & 0xFF0000) >> 16);
                            d3 += (double)((nArray3[i3] & 0xFF00) >> 8);
                            d4 += (double)(nArray3[i3] & 0xFF);
                        }
                        nArray3[0] = AreaAverageOp.clamp((int)(d /= (double)n11)) << 24;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d2 /= (double)n11)) << 16;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d3 /= (double)n11)) << 8;
                        nArray3[0] = nArray3[0] | AreaAverageOp.clamp((int)(d4 /= (double)n11));
                        break;
                    }
                    case 1: {
                        if (nArray != null) {
                            short[] sArray = (short[])object;
                            for (int i4 = 0; i4 < n12; i4 += n6) {
                                d += (double)((sArray[i4] & nArray[0]) >> nArray2[0]);
                                if (nArray.length <= 1) continue;
                                d2 += (double)((sArray[i4] & nArray[1]) >> nArray2[1]);
                                d3 += (double)((sArray[i4] & nArray[2]) >> nArray2[2]);
                                if (nArray.length <= 3) continue;
                                d4 += (double)((sArray[i4] & nArray[3]) >> nArray2[3]);
                            }
                            d2 /= (double)n11;
                            d3 /= (double)n11;
                            d4 /= (double)n11;
                            sArray[0] = (short)((int)(d /= (double)n11) << nArray2[0] & nArray[0]);
                            if (nArray.length <= 1) break;
                            sArray[0] = (short)(sArray[0] | (short)((int)d2 << nArray2[1] & nArray[1]));
                            sArray[0] = (short)(sArray[0] | (short)((int)d3 << nArray2[2] & nArray[2]));
                            if (nArray.length <= 3) break;
                            sArray[0] = (short)(sArray[0] | (short)((int)d4 << nArray2[3] & nArray[3]));
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("TransferType not supported: " + n8);
                    }
                }
                writableRaster.setDataElements(k, i, 1, 1, object);
            }
        }
        return writableRaster;
    }

    private static int clamp(int n2) {
        return n2 > 255 ? 255 : n2;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        ColorModel colorModel2 = colorModel != null ? colorModel : bufferedImage.getColorModel();
        return new BufferedImage(colorModel2, ImageUtil.createCompatibleWritableRaster(bufferedImage, colorModel2, this.width, this.height), colorModel2.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster(this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds2D(Raster raster) {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("2006-Lamborghini-Gallardo-Spyder-Y-T-1600x1200.png"));
        for (int i = 0; i < 100; ++i) {
        }
        long l = System.currentTimeMillis();
        bufferedImage = new AreaAverageOp(500, 600).filter(bufferedImage, null);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("time: " + l2 + " ms");
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new JScrollPane(new JLabel(new BufferedImageIcon(bufferedImage))));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

