/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.metadata.tiff;

public final class Half
extends Number
implements Comparable<Half> {
    public static final int SIZE = 16;
    private final short shortBits;
    private final transient float floatValue;

    public Half(short s) {
        this.shortBits = s;
        this.floatValue = Half.shortBitsToFloat(s);
    }

    @Override
    public int intValue() {
        return (int)this.floatValue;
    }

    @Override
    public long longValue() {
        return (long)this.floatValue;
    }

    @Override
    public float floatValue() {
        return this.floatValue;
    }

    @Override
    public double doubleValue() {
        return this.floatValue;
    }

    public int hashCode() {
        return this.shortBits;
    }

    public boolean equals(Object object) {
        return object instanceof Half && ((Half)object).shortBits == this.shortBits;
    }

    @Override
    public int compareTo(Half half) {
        return Float.compare(this.floatValue, half.floatValue);
    }

    public String toString() {
        return Float.toString(this.floatValue);
    }

    public static Half valueOf(String string) throws NumberFormatException {
        return new Half(Half.parseHalf(string));
    }

    public static short parseHalf(String string) throws NumberFormatException {
        return Half.floatToShortBits(Float.parseFloat(string));
    }

    public static float shortBitsToFloat(short s) {
        int n2 = s & 0x3FF;
        int n3 = s & 0x7C00;
        if (n3 == 31744) {
            n3 = 261120;
        } else if (n3 != 0) {
            n3 += 114688;
        } else if (n2 != 0) {
            n3 = 115712;
            do {
                n3 -= 1024;
            } while (((n2 <<= 1) & 0x400) == 0);
            n2 &= 0x3FF;
        }
        return Float.intBitsToFloat((s & 0x8000) << 16 | (n3 | n2) << 13);
    }

    public static short floatToShortBits(float f) {
        return (short)Half.floatTo16Bits(f);
    }

    private static int floatTo16Bits(float f) {
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 >>> 16 & 0x8000;
        int n4 = (n2 & Integer.MAX_VALUE) + 4096;
        if (n4 >= 1199570944) {
            if ((n2 & Integer.MAX_VALUE) >= 1199570944) {
                if (n4 < 2139095040) {
                    return n3 | 0x7C00;
                }
                return n3 | 0x7C00 | (n2 & 0x7FFFFF) >>> 13;
            }
            return n3 | 0x7BFF;
        }
        if (n4 >= 0x38800000) {
            return n3 | n4 - 0x38000000 >>> 13;
        }
        if (n4 < 0x33000000) {
            return n3;
        }
        n4 = (n2 & Integer.MAX_VALUE) >>> 23;
        return n3 | (n2 & 0x7FFFFF | 0x800000) + (0x800000 >>> n4 - 102) >>> 126 - n4;
    }

    private Object readResolve() {
        return new Half(this.shortBits);
    }
}

