/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.plugins.webp.lossless;

import java.awt.image.WritableRaster;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;

final class ColorIndexingTransform
implements Transform {
    private final byte[] colorTable;
    private final byte bits;

    public ColorIndexingTransform(byte[] byArray, byte by) {
        this.colorTable = byArray;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int j = 0; j < n2; ++j) {
            for (int k = n - 1; k >= 0; --k) {
                int n3 = 8 >> this.bits;
                int n4 = 1 << this.bits;
                int n5 = k / n4;
                int n6 = n3 * (k % n4);
                int n7 = writableRaster.getSample(n5, j, 1);
                int n8 = n7 >> n6 & (1 << n3) - 1;
                System.arraycopy(this.colorTable, n8 * 4, byArray, 0, 4);
                writableRaster.setDataElements(k, j, byArray);
            }
        }
    }
}

