/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.mojang.nbt.ByteArrayTag;
import com.mojang.nbt.ByteTag;
import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.IntTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.LongTag;
import com.mojang.nbt.ShortTag;
import com.mojang.nbt.StringTag;
import com.mojang.nbt.Tag;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.item.ItemStack;

public class NbtUtils {
    public static CompoundTag getNbt(Entity entity) {
        return entity != null ? NbtUtils.serializeNBT(entity) : new CompoundTag();
    }

    public static CompoundTag getNbt(ItemStack stack) {
        CompoundTag result = new CompoundTag();
        return stack != null ? stack.writeToNBT(result) : result;
    }

    public static Tag<?> getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            Entity entity = (Entity)data;
            return NbtUtils.getNbt(entity, path);
        }
        if (data instanceof ItemStack) {
            ItemStack stack = (ItemStack)data;
            return NbtUtils.getNbt(stack, path);
        }
        return null;
    }

    public static Tag<?> getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static Tag<?> getNbt(ItemStack stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static Tag<?> getNbt(CompoundTag root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        CompoundTag currentTag = root;
        block0: for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof CompoundTag) {
                CompoundTag temp = currentTag;
                for (Tag nbt : temp.getValues()) {
                    if (!nbt.getTagName().equals(path[i])) continue;
                    currentTag = nbt;
                    continue block0;
                }
                continue;
            }
            if (currentTag instanceof ListTag) {
                ListTag list = (ListTag)currentTag;
                int index = Integer.parseInt(path[i]);
                currentTag = list.tagAt(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(Tag<?> tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getId()) {
            case 1: {
                return ((ByteTag)tag).getValue();
            }
            case 2: {
                return ((ShortTag)tag).getValue();
            }
            case 3: {
                return ((IntTag)tag).getValue();
            }
            case 4: {
                return ((LongTag)tag).getValue();
            }
            case 5: {
                return ((FloatTag)tag).getValue();
            }
            case 6: {
                return ((DoubleTag)tag).getValue();
            }
            case 7: {
                return ((ByteArrayTag)tag).getValue();
            }
            case 8: {
                return ((StringTag)tag).getValue();
            }
            case 9: {
                ListTag list = (ListTag)tag;
                List converted = StringUtils.newArrayList();
                if (list.tagCount() <= 0) {
                    for (int i = 0; i < list.tagCount(); ++i) {
                        converted.add(NbtUtils.parseTag(list.tagAt(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    return tag.toString();
                }
            }
        }
        return tag;
    }

    public static CompoundTag serializeNBT(Entity entity) {
        String name = EntityDispatcher.getEntityString((Entity)entity);
        CompoundTag ret = new CompoundTag();
        if (!StringUtils.isNullOrEmpty(name)) {
            ret.putString("id", name);
        }
        entity.saveWithoutId(ret);
        return ret;
    }
}

