/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherRain;
import net.minecraft.core.world.weather.WeatherSnow;
import net.minecraft.core.world.weather.WeatherStorm;

public class WorldUtils {
    public static World getWorld(Minecraft client) {
        return client != null ? client.theWorld : null;
    }

    public static World getWorld(Entity entity) {
        return entity != null ? entity.world : null;
    }

    public static EntityPlayer getPlayer(Minecraft client) {
        return client != null ? client.thePlayer : null;
    }

    public static String getEntityName(Entity entity, boolean stripFormatting) {
        String result = "";
        if (entity != null) {
            result = StringUtils.getOrDefault(EntityDispatcher.getEntityString((Entity)entity));
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getEntityName(Entity entity) {
        return WorldUtils.getEntityName(entity, true);
    }

    public static String getWeather(World world) {
        String name = "clear";
        if (world != null) {
            Weather info = world.getCurrentWeather();
            name = info instanceof WeatherStorm ? "thunder" : (info instanceof WeatherRain || info instanceof WeatherSnow ? "rain" : "clear");
        }
        return name;
    }

    public static String getWeather(Entity entity) {
        return WorldUtils.getWeather(WorldUtils.getWorld(entity));
    }
}

