/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={KeyBindMapping.class, ConversionMode.class})
public class KeyConverter {
    private static final List<KeyBindMapping> keyMappings = StringUtils.newArrayList(new KeyBindMapping(0, -1, "None"), new KeyBindMapping(1, 256, "Escape"), new KeyBindMapping(2, 49, "1"), new KeyBindMapping(3, 50, "2"), new KeyBindMapping(4, 51, "3"), new KeyBindMapping(5, 52, "4"), new KeyBindMapping(6, 53, "5"), new KeyBindMapping(7, 54, "6"), new KeyBindMapping(8, 55, "7"), new KeyBindMapping(9, 56, "8"), new KeyBindMapping(10, 57, "9"), new KeyBindMapping(11, 48, "0"), new KeyBindMapping(12, 45, "Minus"), new KeyBindMapping(13, 61, "Equals"), new KeyBindMapping(14, 259, "Backspace"), new KeyBindMapping(15, 258, "Tab"), new KeyBindMapping(16, 81, "Q"), new KeyBindMapping(17, 87, "W"), new KeyBindMapping(18, 69, "E"), new KeyBindMapping(19, 82, "R"), new KeyBindMapping(20, 84, "T"), new KeyBindMapping(21, 89, "Y"), new KeyBindMapping(22, 85, "U"), new KeyBindMapping(23, 73, "I"), new KeyBindMapping(24, 79, "O"), new KeyBindMapping(25, 80, "P"), new KeyBindMapping(26, 91, "Left Bracket"), new KeyBindMapping(27, 93, "Right Bracket"), new KeyBindMapping(28, 257, "Return"), new KeyBindMapping(29, 341, "Left Control"), new KeyBindMapping(30, 65, "A"), new KeyBindMapping(31, 83, "S"), new KeyBindMapping(32, 68, "D"), new KeyBindMapping(33, 70, "F"), new KeyBindMapping(34, 71, "G"), new KeyBindMapping(35, 72, "H"), new KeyBindMapping(36, 74, "J"), new KeyBindMapping(37, 75, "K"), new KeyBindMapping(38, 76, "L"), new KeyBindMapping(39, 59, "Semicolon"), new KeyBindMapping(40, 39, "Apostrophe"), new KeyBindMapping(41, 96, "Grave"), new KeyBindMapping(42, 340, "Left Shift"), new KeyBindMapping(43, 92, "Backslash"), new KeyBindMapping(44, 90, "Z"), new KeyBindMapping(45, 88, "X"), new KeyBindMapping(46, 67, "C"), new KeyBindMapping(47, 86, "V"), new KeyBindMapping(48, 66, "B"), new KeyBindMapping(49, 78, "N"), new KeyBindMapping(50, 77, "M"), new KeyBindMapping(51, 44, "Comma"), new KeyBindMapping(52, 46, "Period"), new KeyBindMapping(53, 47, "Slash"), new KeyBindMapping(54, 344, "Right Shift"), new KeyBindMapping(55, 332, "Keypad - Multiply"), new KeyBindMapping(56, 342, "Left Alt"), new KeyBindMapping(57, 32, "Space"), new KeyBindMapping(58, 280, "Caps Lock"), new KeyBindMapping(59, 290, "F1"), new KeyBindMapping(60, 291, "F2"), new KeyBindMapping(61, 292, "F3"), new KeyBindMapping(62, 293, "F4"), new KeyBindMapping(63, 294, "F5"), new KeyBindMapping(64, 295, "F6"), new KeyBindMapping(65, 296, "F7"), new KeyBindMapping(66, 297, "F8"), new KeyBindMapping(67, 298, "F9"), new KeyBindMapping(68, 299, "F10"), new KeyBindMapping(69, 282, "Number Lock"), new KeyBindMapping(70, 281, "Scroll Lock"), new KeyBindMapping(71, 327, "Keypad - 7"), new KeyBindMapping(72, 328, "Keypad - 8"), new KeyBindMapping(73, 329, "Keypad - 9"), new KeyBindMapping(74, 333, "Keypad - Subtract"), new KeyBindMapping(75, 324, "Keypad - 4"), new KeyBindMapping(76, 325, "Keypad - 5"), new KeyBindMapping(77, 326, "Keypad - 6"), new KeyBindMapping(78, 334, "Keypad - Add"), new KeyBindMapping(79, 321, "Keypad - 1"), new KeyBindMapping(80, 322, "Keypad - 2"), new KeyBindMapping(81, 323, "Keypad - 3"), new KeyBindMapping(82, 320, "Keypad - 0"), new KeyBindMapping(83, 330, "Keypad - Decimal"), new KeyBindMapping(87, 300, "F11"), new KeyBindMapping(88, 301, "F12"), new KeyBindMapping(100, 302, "F13"), new KeyBindMapping(101, 303, "F14"), new KeyBindMapping(102, 304, "F15"), new KeyBindMapping(103, 305, "F16"), new KeyBindMapping(104, 306, "F17"), new KeyBindMapping(105, 307, "F18"), new KeyBindMapping(113, 308, "F19"), new KeyBindMapping(141, 336, "Keypad - Equals"), new KeyBindMapping(156, 335, "Keypad - Enter"), new KeyBindMapping(157, 345, "Right Control"), new KeyBindMapping(181, 331, "Keypad - Divide"), new KeyBindMapping(184, 346, "Right Alt"), new KeyBindMapping(197, 284, "Pause"), new KeyBindMapping(199, 268, "Home"), new KeyBindMapping(200, 265, "Up Arrow"), new KeyBindMapping(201, 266, "Page Up"), new KeyBindMapping(203, 263, "Left Arrow"), new KeyBindMapping(205, 262, "Right Arrow"), new KeyBindMapping(207, 269, "End"), new KeyBindMapping(208, 264, "Down Arrow"), new KeyBindMapping(209, 267, "Page Down"), new KeyBindMapping(210, 260, "Insert"), new KeyBindMapping(211, 261, "Delete"), new KeyBindMapping(219, 343, "Left Meta"), new KeyBindMapping(220, 347, "Right Meta"));
    private static final List<KeyBindMapping> lwjgl2KeyMappings = StringUtils.newArrayList(new KeyBindMapping(112, -1, "Kana"), new KeyBindMapping(121, -1, "Convert"), new KeyBindMapping(123, -1, "NoConvert"), new KeyBindMapping(125, -1, "Symbol - Yen"), new KeyBindMapping(144, -1, "Symbol - Circumflex"), new KeyBindMapping(145, -1, "Symbol - At"), new KeyBindMapping(146, -1, "Symbol - Colon"), new KeyBindMapping(147, -1, "Underline"), new KeyBindMapping(148, -1, "Kanji"), new KeyBindMapping(149, -1, "Stop"), new KeyBindMapping(150, -1, "AX"), new KeyBindMapping(151, -1, "Unlabeled"), new KeyBindMapping(179, -1, "Keypad - Comma"), new KeyBindMapping(183, -1, "SysRq"), new KeyBindMapping(196, -1, "Function"), new KeyBindMapping(221, -1, "Apps"), new KeyBindMapping(222, -1, "Power"), new KeyBindMapping(223, -1, "Sleep"));
    public static final Map<Integer, KeyBindMapping> toGlfw = KeyConverter.generateKeyStream(keyMappings, lwjgl2KeyMappings).collect(Collectors.toMap((Function<KeyBindMapping, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lwjgl2Key(), (Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)Ljava/lang/Integer;)(), (Function<KeyBindMapping, KeyBindMapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$0(com.gitlab.cdagaming.unilib.core.impl.KeyConverter$KeyBindMapping ), (Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)()));
    private static final List<KeyBindMapping> lwjgl3KeyMappings = StringUtils.newArrayList(new KeyBindMapping(0, 161, "WORLD_1"), new KeyBindMapping(0, 162, "WORLD_2"), new KeyBindMapping(0, 283, "Print Screen"), new KeyBindMapping(0, 309, "F20"), new KeyBindMapping(0, 310, "F21"), new KeyBindMapping(0, 311, "F22"), new KeyBindMapping(0, 312, "F23"), new KeyBindMapping(0, 313, "F24"), new KeyBindMapping(0, 314, "F25"), new KeyBindMapping(0, 348, "KEY_MENU"));
    public static final Map<Integer, KeyBindMapping> fromGlfw = KeyConverter.generateKeyStream(keyMappings, lwjgl3KeyMappings).collect(Collectors.toMap((Function<KeyBindMapping, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lwjgl3Key(), (Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)Ljava/lang/Integer;)(), (Function<KeyBindMapping, KeyBindMapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$static$1(com.gitlab.cdagaming.unilib.core.impl.KeyConverter$KeyBindMapping ), (Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)Lcom/gitlab/cdagaming/unilib/core/impl/KeyConverter$KeyBindMapping;)()));
    private static final Map<Integer, Predicate<Integer>> lwjgl2KeyConditions = StringUtils.newHashMap();
    private static final Map<Integer, Predicate<Integer>> lwjgl3KeyConditions = StringUtils.newHashMap();
    private static final List<Integer> lwjgl2ClearKeys = StringUtils.newArrayList(1);
    private static final List<Integer> lwjgl3ClearKeys = StringUtils.newArrayList(256);

    private static Stream<KeyBindMapping> generateKeyStream(List<KeyBindMapping> mappings, List<KeyBindMapping> extras) {
        List<KeyBindMapping> results = StringUtils.newArrayList(mappings);
        if (extras != null && !extras.isEmpty()) {
            results.addAll(extras);
        }
        return results.stream();
    }

    private static Stream<KeyBindMapping> generateKeyStream(List<KeyBindMapping> mappings) {
        return KeyConverter.generateKeyStream(mappings, null);
    }

    public static boolean isValidKeyCode(int sourceKeyCode, int protocol) {
        Map<Integer, Predicate<Integer>> keyConditions;
        Map<Integer, Predicate<Integer>> map = keyConditions = protocol > 340 ? lwjgl3KeyConditions : lwjgl2KeyConditions;
        if (keyConditions.containsKey(sourceKeyCode)) {
            return keyConditions.get(sourceKeyCode).test(protocol);
        }
        return true;
    }

    public static boolean isValidClearCode(int sourceKeyCode, int protocol) {
        List<Integer> clearKeys = protocol > 340 ? lwjgl3ClearKeys : lwjgl2ClearKeys;
        return clearKeys.contains(sourceKeyCode);
    }

    public static String getKeyName(int original, int protocol, BiFunction<Integer, Integer, String> fallback) {
        boolean isLwjgl2 = protocol <= 340;
        int unknownKeyCode = isLwjgl2 ? -1 : 0;
        String unknownKeyName = (isLwjgl2 ? fromGlfw : toGlfw).get(unknownKeyCode).name();
        if (KeyConverter.isValidKeyCode(original, protocol)) {
            Map<Integer, KeyBindMapping> mappings;
            Map<Integer, KeyBindMapping> map = mappings = isLwjgl2 ? toGlfw : fromGlfw;
            if (mappings.containsKey(original)) {
                return mappings.get(original).name();
            }
            if (fallback != null && original != unknownKeyCode) {
                return StringUtils.getOrDefault(fallback.apply(original, protocol), Integer.toString(original));
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    public static int convertKey(int originalKey, int protocol, ConversionMode mode) {
        int resultKey;
        KeyBindMapping unknownKeyData = mode == ConversionMode.Lwjgl2 ? fromGlfw.get(-1) : toGlfw.get(0);
        int n = resultKey = protocol <= 340 ? -1 : 0;
        if (mode == ConversionMode.Lwjgl2) {
            resultKey = fromGlfw.getOrDefault(originalKey, unknownKeyData).lwjgl2Key();
        } else if (mode == ConversionMode.Lwjgl3) {
            resultKey = toGlfw.getOrDefault(originalKey, unknownKeyData).lwjgl3Key();
        } else if (mode == ConversionMode.None) {
            if (protocol <= 340 && toGlfw.containsKey(originalKey)) {
                resultKey = originalKey;
            } else if (protocol > 340 && fromGlfw.containsKey(originalKey)) {
                resultKey = originalKey;
            }
        }
        if (resultKey == originalKey && mode != ConversionMode.None) {
            CoreUtils.LOG.warn("Unexpected KeyConverter result for object \"%1$s\". Please report this issue. (Mode Attempted: %2$s)", Integer.toString(resultKey), mode.name());
        }
        return resultKey;
    }

    private static /* synthetic */ KeyBindMapping lambda$static$1(KeyBindMapping mapping) {
        return mapping;
    }

    private static /* synthetic */ KeyBindMapping lambda$static$0(KeyBindMapping mapping) {
        return mapping;
    }

    @RecordComponents(value={@RecordComponents.Value(name="lwjgl2Key", type=int.class), @RecordComponents.Value(name="lwjgl3Key", type=int.class), @RecordComponents.Value(name="name", type=String.class)})
    @NestHost(value=KeyConverter.class)
    public static final class KeyBindMapping
    extends J_L_Record {
        private final int lwjgl2Key;
        private final int lwjgl3Key;
        private final String name;

        public KeyBindMapping(int lwjgl2Key, int lwjgl3Key, String name) {
            this.lwjgl2Key = lwjgl2Key;
            this.lwjgl3Key = lwjgl3Key;
            this.name = name;
        }

        @Override
        public final String toString() {
            return KeyBindMapping.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return KeyBindMapping.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return KeyBindMapping.jvmdowngrader$equals$equals(this, o);
        }

        public int lwjgl2Key() {
            return this.lwjgl2Key;
        }

        public int lwjgl3Key() {
            return this.lwjgl3Key;
        }

        public String name() {
            return this.name;
        }

        private static String jvmdowngrader$toString$toString(KeyBindMapping keyBindMapping) {
            KeyBindMapping keyBindMapping2 = keyBindMapping;
            return "KeyConverter$KeyBindMapping[" + "lwjgl2Key=" + keyBindMapping.lwjgl2Key + ", " + "lwjgl3Key=" + keyBindMapping.lwjgl3Key + ", " + "name=" + keyBindMapping.name + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(KeyBindMapping keyBindMapping) {
            Object[] objectArray = new Object[]{keyBindMapping.lwjgl2Key, keyBindMapping.lwjgl3Key, keyBindMapping.name};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(KeyBindMapping keyBindMapping, Object object) {
            if (keyBindMapping == object) {
                return true;
            }
            if (object != null && object instanceof KeyBindMapping) {
                KeyBindMapping keyBindMapping2 = (KeyBindMapping)object;
                if (keyBindMapping.lwjgl2Key == keyBindMapping2.lwjgl2Key && keyBindMapping.lwjgl3Key == keyBindMapping2.lwjgl3Key && Objects.equals(keyBindMapping.name, keyBindMapping2.name)) {
                    return true;
                }
            }
            return false;
        }

        public int jvmdowngrader$handleNest$com_gitlab_cdagaming_unilib_core_impl_KeyConverter$KeyBindMapping$get$lwjgl3Key() {
            return this.lwjgl3Key;
        }

        public void jvmdowngrader$handleNest$com_gitlab_cdagaming_unilib_core_impl_KeyConverter$KeyBindMapping$set$lwjgl3Key(int n) {
            this.lwjgl3Key = n;
        }

        public int jvmdowngrader$handleNest$com_gitlab_cdagaming_unilib_core_impl_KeyConverter$KeyBindMapping$get$lwjgl2Key() {
            return this.lwjgl2Key;
        }

        public void jvmdowngrader$handleNest$com_gitlab_cdagaming_unilib_core_impl_KeyConverter$KeyBindMapping$set$lwjgl2Key(int n) {
            this.lwjgl2Key = n;
        }
    }

    @NestHost(value=KeyConverter.class)
    public static enum ConversionMode {
        Lwjgl2,
        Lwjgl3,
        None,
        Unknown;

    }
}

