/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;

public class ScrollPane
extends ExtendedScreen {
    private static final Color NONE = StringUtils.getColorFrom(0, 0, 0, 0);
    private static final int DEFAULT_PADDING = 4;
    private static final int DEFAULT_HEADER_HEIGHT = 4;
    private static final int DEFAULT_FOOTER_HEIGHT = 4;
    private static final int DEFAULT_BAR_WIDTH = 6;
    private static final int DEFAULT_HEIGHT_PER_SCROLL = 8;
    private final ScreenConstants.ColorData DEFAULT_HEADER_BACKGROUND;
    private final ScreenConstants.ColorData DEFAULT_FOOTER_BACKGROUND;
    private final ScreenConstants.ColorData DEFAULT_SCROLLBAR_BACKGROUND;
    private final ScreenConstants.ColorData DEFAULT_SCROLLBAR_BORDER;
    private final ScreenConstants.ColorData DEFAULT_SCROLLBAR_FOREGROUND;
    private boolean clickedScrollbar;
    private int padding;
    private float amountScrolled = 0.0f;
    private int mousePrevX = 0;
    private int mousePrevY = 0;

    public ScrollPane(int startX, int startY, int width, int height, int padding) {
        this.setScreenX(startX);
        this.setScreenY(startY);
        this.setScreenWidth(width);
        this.setScreenHeight(height);
        this.setPadding(padding);
        this.DEFAULT_HEADER_BACKGROUND = new ScreenConstants.ColorData(Color.black, NONE, this.getScreenBackground().texLocation(), 0.0, -100.0, false);
        this.DEFAULT_FOOTER_BACKGROUND = new ScreenConstants.ColorData(NONE, Color.black, this.getScreenBackground().texLocation(), 0.0, -100.0, false);
        this.DEFAULT_SCROLLBAR_BACKGROUND = new ScreenConstants.ColorData(Color.black, Color.black, this.getScreenBackground().texLocation(), 0.0, 0.0, false);
        this.DEFAULT_SCROLLBAR_BORDER = new ScreenConstants.ColorData(Color.gray, Color.gray, this.getScreenBackground().texLocation(), 0.0, 0.0, false);
        this.DEFAULT_SCROLLBAR_FOREGROUND = new ScreenConstants.ColorData(Color.lightGray, Color.lightGray, this.getScreenBackground().texLocation(), 0.0, 0.0, false);
    }

    public ScrollPane(int startX, int startY, int width, int height) {
        this(startX, startY, width, height, 4);
    }

    public ScrollPane(int width, int height, int padding) {
        this(0, 0, width, height, padding);
    }

    public ScrollPane(int width, int height) {
        this(width, height, 4);
    }

    @Override
    public void resetMouseScroll() {
        super.resetMouseScroll();
        this.setScroll(this.getMouseScroll());
    }

    @Override
    public void refreshContentHeight() {
        super.refreshContentHeight();
        this.setContentHeight((int)((float)this.getContentHeight() + this.getAmountScrolled()));
    }

    @Override
    public double getOffset() {
        return this.needsScrollbar() ? (double)this.getAmountScrolled() : super.getOffset();
    }

    @Override
    public float getTintFactor() {
        return 0.5f;
    }

    protected int getHeaderTop() {
        return this.getTop();
    }

    protected int getHeaderHeight() {
        return 4;
    }

    protected int getHeaderBottom() {
        return this.getHeaderTop() + this.getHeaderHeight();
    }

    protected int getFooterTop() {
        return this.getBottom() - this.getFooterHeight();
    }

    protected int getFooterHeight() {
        return 4;
    }

    protected int getFooterBottom() {
        return this.getFooterTop() + this.getFooterHeight();
    }

    protected ScreenConstants.ColorData getHeaderBackground() {
        return this.DEFAULT_HEADER_BACKGROUND;
    }

    protected ScreenConstants.ColorData getFooterBackground() {
        return this.DEFAULT_FOOTER_BACKGROUND;
    }

    protected ScreenConstants.ColorData getScrollbarBackground() {
        return this.DEFAULT_SCROLLBAR_BACKGROUND;
    }

    protected ScreenConstants.ColorData getScrollbarBorder() {
        return this.DEFAULT_SCROLLBAR_BORDER;
    }

    protected ScreenConstants.ColorData getScrollbarForeground() {
        return this.DEFAULT_SCROLLBAR_FOREGROUND;
    }

    protected void renderListSeparators() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getHeaderTop(), this.getHeaderBottom(), 0.0, 1.0f, 0.0, 0.0, this.getHeaderBackground());
        this.drawBackground(this.getLeft(), this.getRight(), this.getFooterTop(), this.getFooterBottom(), 0.0, 1.0f, 0.0, 0.0, this.getFooterBackground());
    }

    protected void renderScrollbar() {
        if (this.needsScrollbar()) {
            int scrollBarX = this.getScrollBarX();
            int scrollBarRight = scrollBarX + this.getScrollBarWidth();
            int bottom = this.getBottom();
            int top = this.getTop();
            int maxScroll = this.getMaxScroll();
            int screenHeight = this.getScreenHeight();
            int height = this.getBarHeight();
            int barTop = Math.max((int)this.getAmountScrolled() * (screenHeight - height) / maxScroll + top, top);
            int barBottom = barTop + height;
            this.drawBackground(scrollBarX, scrollBarRight, top, bottom, 0.0, 1.0f, 0.0, 0.0, this.getScrollbarBackground());
            this.drawBackground(scrollBarX, scrollBarRight, barTop, barBottom, 0.0, 1.0f, 0.0, 0.0, this.getScrollbarBorder());
            this.drawBackground(scrollBarX, scrollBarRight - 1, barTop, barBottom - 1, 0.0, 1.0f, 0.0, 0.0, this.getScrollbarForeground());
        }
    }

    @Override
    public void postRender() {
        this.renderListSeparators();
        this.renderScrollbar();
        super.postRender();
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0;
    }

    @Override
    protected void method_1026(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            this.checkScrollbarClick(mouseX, mouseY, mouseButton);
            this.mousePrevX = mouseX;
            this.mousePrevY = mouseY;
            super.method_1026(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void method_4259(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            this.mouseDragged(mouseX, mouseY, mouseButton, mouseX - this.mousePrevX, mouseY - this.mousePrevY);
            this.mousePrevX = mouseX;
            this.mousePrevY = mouseY;
            super.method_4259(mouseX, mouseY, mouseButton, timeSinceLastClick);
        }
    }

    public void mouseDragged(int mouseX, int mouseY, int button, int deltaX, int deltaY) {
        if (this.isValidMouseClick(button) && this.needsScrollbar() && this.isScrolling()) {
            if (mouseY < this.getTop()) {
                this.setScroll(0.0f);
            } else if (mouseY > this.getBottom()) {
                this.setScroll(this.getMaxScroll());
            } else {
                int height = this.getBarHeight();
                int scrollLimit = Math.max(1, this.getMaxScroll());
                int heightPerScroll = Math.max(1, scrollLimit / (this.getScreenHeight() - height));
                this.scrollBy(deltaY * heightPerScroll);
            }
        }
    }

    @Override
    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        this.scrollBy(-wheelY * this.getHeightPerScroll());
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int newPadding) {
        this.padding = newPadding;
    }

    public int getScrollBarX() {
        return this.getRight() - this.getScrollBarWidth();
    }

    public int getScrollBarWidth() {
        return this.needsScrollbar() ? 6 : 0;
    }

    public int getHeightPerScroll() {
        return 8;
    }

    public void scrollBy(float amount) {
        this.setScroll(this.getAmountScrolled() + amount);
    }

    public void setScroll(float amount) {
        float prevScrollAmount = this.getAmountScrolled();
        this.setAmountScrolled(amount);
        this.bindAmountScrolled();
        if (this.getAmountScrolled() != prevScrollAmount) {
            int scrollDiff = (int)(this.getAmountScrolled() - prevScrollAmount);
            for (DynamicWidget widget : this.getWidgets()) {
                widget.setControlPosY(widget.getControlPosY() - scrollDiff);
            }
        }
    }

    public void checkScrollbarClick(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = this.needsScrollbar() && this.isValidMouseClick(button) && MathUtils.isWithinValue(mouseX, this.getScrollBarX(), this.getScrollBarX() + this.getScrollBarWidth(), true, false);
    }

    public boolean isScrolling() {
        return this.clickedScrollbar;
    }

    public void bindAmountScrolled() {
        this.setAmountScrolled(MathUtils.clamp(this.getAmountScrolled(), 0.0f, (float)this.getMaxScroll()));
    }

    public float getAmountScrolled() {
        return this.amountScrolled;
    }

    public void setAmountScrolled(float scrolled) {
        this.amountScrolled = scrolled;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getBottom() - this.getPadding()));
    }

    public int getBarHeight() {
        if (!this.needsScrollbar()) {
            return 0;
        }
        int barHeight = this.getScreenHeight() * this.getScreenHeight() / this.getContentHeight();
        return MathUtils.clamp(barHeight, 32, this.getScreenHeight() - this.getPadding() * 2);
    }

    public boolean needsScrollbar() {
        return this.getMaxScroll() > 0;
    }

    @Override
    public int getMaxWidth() {
        return this.getScreenWidth() - this.getPadding() - this.getScrollBarWidth();
    }
}

