/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_4185;

public class ExtendedButtonControl
extends class_4185
implements DynamicWidget {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private boolean isOverScreen = false;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, buttonText, button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), x, y, widthIn, heightIn, buttonText, optionalArgs);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(id, xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        this.isOverScreen = RenderUtils.isMouseOver(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.isOverScreen() && this.isHoveringOver()) {
            this.onHover();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        class_310 mc = ModUtils.getMinecraft();
        if (mc != null && this.isControlVisible()) {
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.renderBg(mc, mouseX, mouseY);
            int color = !this.isControlEnabled() ? 0xA0A0A0 : (this.isHoveringOrFocusingOver() ? 0xFFFFA0 : 0xE0E0E0);
            RenderUtils.renderScrollingString(mc, mc.field_1772, this.getControlMessage(), this.getLeft() + 2, this.getTop(), this.getRight() - 2, this.getBottom(), color);
        }
    }

    protected void renderBg(@Nonnull class_310 mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            int hoverState = this.getYImage(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            double xOffset = (double)this.getControlWidth() / 2.0;
            RenderUtils.renderButton(mc, this.getControlPosX(), this.getControlPosY(), 0.0, hoverValue, 200.0 - xOffset, hoverValue, xOffset, this.getControlHeight(), this.getZLevel(), RenderUtils.getButtonTexture(mc));
        }
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.isOverScreen() && this.isControlEnabled() && this.isControlVisible() && this.isHoveringOver();
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.height;
    }

    @Override
    public void setControlHeight(int height) {
        this.height = height;
    }

    @Override
    public int getControlPosX() {
        return this.x;
    }

    @Override
    public void setControlPosX(int posX) {
        this.x = posX;
    }

    @Override
    public int getControlPosY() {
        return this.y;
    }

    @Override
    public void setControlPosY(int posY) {
        this.y = posY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void onPress() {
        this.onClick();
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public class_2561 getControlRawMessage() {
        return new class_2585(this.getMessage());
    }

    public void setControlRawMessage(class_2561 newMessage) {
        this.setMessage(newMessage.getString());
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((class_2561)new class_2585(newMessage));
    }

    public boolean isControlEnabled() {
        return this.active;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.active = isEnabled;
    }

    public boolean isControlVisible() {
        return this.visible;
    }

    public void setControlVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isHoveringOver() {
        return this.isHovered;
    }

    public void setHoveringOver(boolean isHovered) {
        this.isHovered = isHovered;
    }

    public boolean isFocusedOver() {
        return this.isFocused();
    }

    public void setFocusedOver(boolean isFocused) {
        this.setFocused(isFocused);
    }

    public boolean isHoveringOrFocusingOver() {
        return this.isHoveringOver() || this.isFocusedOver();
    }

    public double getZLevel() {
        return this.getBlitOffset();
    }

    public void setZLevel(double zLevel) {
        this.setBlitOffset((int)zLevel);
    }
}

