/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.KeyConverter;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={KeyBindData.class, ImportMode.class})
public class KeyUtils {
    public static final KeyUtils INSTANCE = new KeyUtils();
    public final Map<String, Integer> keySyncQueue = StringUtils.newHashMap();
    private final Map<String, KeyBindData> registrationQueue = StringUtils.newConcurrentHashMap();
    private final Map<String, KeyBindData> KEY_MAPPINGS = StringUtils.newHashMap();
    private final Supplier<Minecraft> instance;
    private final int protocol;

    public KeyUtils(Supplier<Minecraft> instance, int protocol) {
        this.instance = instance;
        this.protocol = protocol;
    }

    public KeyUtils() {
        this(ModUtils.getMinecraftSupplier(), ModUtils.MCProtocolID);
    }

    public Minecraft getInstance() {
        return this.instance.get();
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return KeyConverter.isValidKeyCode(sourceKeyCode, this.protocol);
    }

    public boolean isValidClearCode(int sourceKeyCode) {
        return KeyConverter.isValidClearCode(sourceKeyCode, this.protocol);
    }

    public String getKeyName(int original) {
        return KeyConverter.getKeyName(original, this.protocol, (BiFunction<Integer, Integer, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getKeyName$0(java.lang.Integer java.lang.Integer ), (Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;)());
    }

    private afu createKey(String id, String name, String category, int defaultKey, int currentKey) {
        afu result = new afu(name, defaultKey);
        this.keySyncQueue.put(id, currentKey);
        return result;
    }

    public afu registerKey(String id, String name, Function<String, String> nameFormatter, String category, Function<String, String> categoryFormatter, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        afu keyBind = this.createKey(id, name, category, defaultKey, currentKey);
        KeyBindData keyData = new KeyBindData(keyBind, nameFormatter, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKey$1(java.lang.String ), ()Ljava/lang/String;)((String)category), categoryFormatter, (Supplier<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKey$2(int ), ()Ljava/lang/Integer;)((int)defaultKey), detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
        this.KEY_MAPPINGS.put(id, keyData);
        this.registrationQueue.put(id, keyData);
        return keyBind;
    }

    public afu registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerKey$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), category, (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$registerKey$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public afu registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, category, defaultKey, currentKey, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$registerKey$5(), ()Ljava/lang/String;)(), canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    private void setKey(afu instance, int newKey) {
        instance.d = newKey;
        afu.b();
    }

    public boolean areKeysRegistered() {
        return this.registrationQueue.isEmpty();
    }

    public Set<Map.Entry<String, KeyBindData>> getRegistrationEntries() {
        return this.registrationQueue.entrySet();
    }

    public Set<String> getKeys() {
        return this.KEY_MAPPINGS.keySet();
    }

    public Set<Map.Entry<String, KeyBindData>> getKeyEntries() {
        return this.KEY_MAPPINGS.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        if (this.instance == null || this.getInstance() == null) {
            return;
        }
        if (!this.areKeysRegistered()) {
            if (this.getInstance().A != null) {
                for (Map.Entry<String, KeyBindData> data : this.getRegistrationEntries()) {
                    KeyBindData entry = data.getValue();
                    this.getInstance().A.A = StringUtils.addToArray(this.getInstance().A.A, entry.binding());
                    this.registrationQueue.remove(data.getKey());
                }
            } else {
                return;
            }
        }
        if (Keyboard.isCreated()) {
            boolean isLwjgl2 = this.protocol <= 340;
            int unknownKeyCode = isLwjgl2 ? -1 : 0;
            String unknownKeyName = (isLwjgl2 ? KeyConverter.fromGlfw : KeyConverter.toGlfw).get(unknownKeyCode).name();
            try {
                for (Map.Entry<String, KeyBindData> entry : this.getKeyEntries()) {
                    String keyName = entry.getKey();
                    KeyBindData keyData = entry.getValue();
                    if (!keyData.canCheck()) continue;
                    int currentBind = keyData.keyCode();
                    boolean hasBeenRun = false;
                    if (!this.getKeyName(currentBind).equals(unknownKeyName) && !this.isValidClearCode(currentBind) && Keyboard.isKeyDown((int)currentBind) && !(GameUtils.getCurrentScreen(this.getInstance()) instanceof oz)) {
                        try {
                            keyData.runEvent().run();
                        }
                        catch (Throwable ex) {
                            boolean resetKey;
                            if (keyData.errorCallback() != null) {
                                resetKey = keyData.errorCallback().apply(ex, new Pair<String, KeyBindData>(keyName, keyData));
                            } else {
                                CoreUtils.LOG.error(ex);
                                resetKey = true;
                            }
                            if (resetKey) {
                                this.syncKeyData(keyName, ImportMode.Specific, keyData.defaultKeyCode());
                            }
                        }
                        finally {
                            hasBeenRun = true;
                        }
                    }
                    if (hasBeenRun || !keyData.canSync()) continue;
                    if (this.keySyncQueue.containsKey(keyName)) {
                        this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                        this.keySyncQueue.remove(keyName);
                        continue;
                    }
                    if (!keyData.vanillaPredicate().test(currentBind)) continue;
                    this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                }
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        KeyBindData keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            this.setKey(keyData.binding(), keyCode);
        } else if (mode == ImportMode.Vanilla) {
            keyData.configEvent().accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(keyData.description(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        }
    }

    public Map<String, KeyBindData> getKeyMappings(List<String> filterData) {
        Map<String, KeyBindData> filteredMappings = StringUtils.newHashMap();
        if (filterData == null || filterData.isEmpty()) {
            filteredMappings.putAll(this.KEY_MAPPINGS);
            return filteredMappings;
        }
        for (Map.Entry<String, KeyBindData> entry : this.getKeyEntries()) {
            String keyName = entry.getKey();
            KeyBindData keyData = entry.getValue();
            if (!filterData.contains(keyData.category())) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, KeyBindData> getKeyMappings(String ... filterData) {
        return this.getKeyMappings(filterData == null || filterData.length == 0 ? null : StringUtils.newArrayList(filterData));
    }

    private static /* synthetic */ String lambda$registerKey$5() {
        return "";
    }

    private static /* synthetic */ String lambda$registerKey$4(String categoryName) {
        return categoryName;
    }

    private static /* synthetic */ String lambda$registerKey$3(String description) {
        return description;
    }

    private static /* synthetic */ Integer lambda$registerKey$2(int defaultKey) {
        return defaultKey;
    }

    private static /* synthetic */ String lambda$registerKey$1(String category) {
        return category;
    }

    private static /* synthetic */ String lambda$getKeyName$0(Integer originalKeyCode, Integer inputProtocol) {
        return Keyboard.getKeyName((int)originalKeyCode);
    }

    @RecordComponents(value={@RecordComponents.Value(name="binding", type=afu.class), @RecordComponents.Value(name="nameFormatter", type=Function.class), @RecordComponents.Value(name="categorySupplier", type=Supplier.class), @RecordComponents.Value(name="categoryFormatter", type=Function.class), @RecordComponents.Value(name="defaultKeySupplier", type=Supplier.class), @RecordComponents.Value(name="detailsSupplier", type=Supplier.class), @RecordComponents.Value(name="canCheckSupplier", type=Supplier.class), @RecordComponents.Value(name="canSyncSupplier", type=Supplier.class), @RecordComponents.Value(name="runEvent", type=Runnable.class), @RecordComponents.Value(name="configEvent", type=BiConsumer.class), @RecordComponents.Value(name="vanillaPredicate", type=Predicate.class), @RecordComponents.Value(name="errorCallback", type=BiFunction.class)})
    @NestHost(value=KeyUtils.class)
    public static final class KeyBindData
    extends J_L_Record {
        private final afu binding;
        private final Function<String, String> nameFormatter;
        private final Supplier<String> categorySupplier;
        private final Function<String, String> categoryFormatter;
        private final Supplier<Integer> defaultKeySupplier;
        private final Supplier<String> detailsSupplier;
        private final Supplier<Boolean> canCheckSupplier;
        private final Supplier<Boolean> canSyncSupplier;
        private final Runnable runEvent;
        private final BiConsumer<Integer, Boolean> configEvent;
        private final Predicate<Integer> vanillaPredicate;
        private final BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> errorCallback;

        public KeyBindData(afu binding, Function<String, String> nameFormatter, Supplier<String> categorySupplier, Function<String, String> categoryFormatter, Supplier<Integer> defaultKeySupplier, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable runEvent, BiConsumer<Integer, Boolean> configEvent, Predicate<Integer> vanillaPredicate, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> errorCallback) {
            this.binding = binding;
            this.nameFormatter = nameFormatter;
            this.categorySupplier = categorySupplier;
            this.categoryFormatter = categoryFormatter;
            this.defaultKeySupplier = defaultKeySupplier;
            this.detailsSupplier = detailsSupplier;
            this.canCheckSupplier = canCheckSupplier;
            this.canSyncSupplier = canSyncSupplier;
            this.runEvent = runEvent;
            this.configEvent = configEvent;
            this.vanillaPredicate = vanillaPredicate;
            this.errorCallback = errorCallback;
        }

        public String category() {
            return this.categorySupplier().get();
        }

        public String categoryName() {
            return this.categoryFormatter().apply(this.category());
        }

        public String details() {
            return this.detailsSupplier().get();
        }

        public boolean canCheck() {
            return this.canCheckSupplier.get();
        }

        public boolean canSync() {
            return this.canSyncSupplier.get();
        }

        public String description() {
            return this.binding().c;
        }

        public String displayName() {
            return this.nameFormatter().apply(this.description());
        }

        public int keyCode() {
            return this.binding().d;
        }

        public int defaultKeyCode() {
            return this.defaultKeySupplier().get();
        }

        @Override
        public final String toString() {
            return KeyBindData.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return KeyBindData.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return KeyBindData.jvmdowngrader$equals$equals(this, o);
        }

        public afu binding() {
            return this.binding;
        }

        public Function<String, String> nameFormatter() {
            return this.nameFormatter;
        }

        public Supplier<String> categorySupplier() {
            return this.categorySupplier;
        }

        public Function<String, String> categoryFormatter() {
            return this.categoryFormatter;
        }

        public Supplier<Integer> defaultKeySupplier() {
            return this.defaultKeySupplier;
        }

        public Supplier<String> detailsSupplier() {
            return this.detailsSupplier;
        }

        public Supplier<Boolean> canCheckSupplier() {
            return this.canCheckSupplier;
        }

        public Supplier<Boolean> canSyncSupplier() {
            return this.canSyncSupplier;
        }

        public Runnable runEvent() {
            return this.runEvent;
        }

        public BiConsumer<Integer, Boolean> configEvent() {
            return this.configEvent;
        }

        public Predicate<Integer> vanillaPredicate() {
            return this.vanillaPredicate;
        }

        public BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> errorCallback() {
            return this.errorCallback;
        }

        private static String jvmdowngrader$toString$toString(KeyBindData keyBindData) {
            KeyBindData keyBindData2 = keyBindData;
            return "KeyUtils$KeyBindData[" + "binding=" + keyBindData.binding + ", " + "nameFormatter=" + keyBindData.nameFormatter + ", " + "categorySupplier=" + keyBindData.categorySupplier + ", " + "categoryFormatter=" + keyBindData.categoryFormatter + ", " + "defaultKeySupplier=" + keyBindData.defaultKeySupplier + ", " + "detailsSupplier=" + keyBindData.detailsSupplier + ", " + "canCheckSupplier=" + keyBindData.canCheckSupplier + ", " + "canSyncSupplier=" + keyBindData.canSyncSupplier + ", " + "runEvent=" + keyBindData.runEvent + ", " + "configEvent=" + keyBindData.configEvent + ", " + "vanillaPredicate=" + keyBindData.vanillaPredicate + ", " + "errorCallback=" + keyBindData.errorCallback + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(KeyBindData keyBindData) {
            Object[] objectArray = new Object[]{keyBindData.binding, keyBindData.nameFormatter, keyBindData.categorySupplier, keyBindData.categoryFormatter, keyBindData.defaultKeySupplier, keyBindData.detailsSupplier, keyBindData.canCheckSupplier, keyBindData.canSyncSupplier, keyBindData.runEvent, keyBindData.configEvent, keyBindData.vanillaPredicate, keyBindData.errorCallback};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(KeyBindData keyBindData, Object object) {
            if (keyBindData == object) {
                return true;
            }
            if (object != null && object instanceof KeyBindData) {
                KeyBindData keyBindData2 = (KeyBindData)object;
                if (Objects.equals(keyBindData.binding, keyBindData2.binding) && Objects.equals(keyBindData.nameFormatter, keyBindData2.nameFormatter) && Objects.equals(keyBindData.categorySupplier, keyBindData2.categorySupplier) && Objects.equals(keyBindData.categoryFormatter, keyBindData2.categoryFormatter) && Objects.equals(keyBindData.defaultKeySupplier, keyBindData2.defaultKeySupplier) && Objects.equals(keyBindData.detailsSupplier, keyBindData2.detailsSupplier) && Objects.equals(keyBindData.canCheckSupplier, keyBindData2.canCheckSupplier) && Objects.equals(keyBindData.canSyncSupplier, keyBindData2.canSyncSupplier) && Objects.equals(keyBindData.runEvent, keyBindData2.runEvent) && Objects.equals(keyBindData.configEvent, keyBindData2.configEvent) && Objects.equals(keyBindData.vanillaPredicate, keyBindData2.vanillaPredicate) && Objects.equals(keyBindData.errorCallback, keyBindData2.errorCallback)) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=KeyUtils.class)
    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }
}

