/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.widgets;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget$jvmdg$StaticDefaults;
import io.github.cdagaming.unicore.utils.StringUtils;

public class ButtonWidget
extends ExtendedButtonControl {
    private String title;
    private int titleLeft;
    private int titleRight;
    private boolean setDimensions = false;
    private Runnable titleHoverEvent = null;

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        super(buttonId, 0, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setTitle(title);
        this.setOnTitleHover(titleHoverEvent);
    }

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(buttonId, y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ButtonWidget(int buttonId, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(buttonId, y, widthIn, heightIn, buttonText, onPushEvent, title, titleHoverEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(y, widthIn, heightIn, buttonText, title, titleHoverEvent, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ButtonWidget(int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String title, Runnable titleHoverEvent, String ... optionalArgs) {
        this(y, widthIn, heightIn, buttonText, onPushEvent, title, titleHoverEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public boolean hasTitle() {
        return !StringUtils.isNullOrEmpty(this.getTitle());
    }

    public String getTitle() {
        return this.title;
    }

    public ButtonWidget setTitle(String title) {
        this.title = title;
        return this;
    }

    public void setOnTitleHover(Runnable event) {
        this.titleHoverEvent = event;
    }

    public void onTitleHover() {
        if (this.titleHoverEvent != null) {
            this.titleHoverEvent.run();
        }
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        if (!this.setDimensions) {
            int middle = screen.getScreenWidth() / 2;
            this.setControlPosX(middle + 3);
            this.titleLeft = middle - 180;
            this.titleRight = middle - 6;
            this.setDimensions = true;
        }
        super.preDraw(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (this.hasTitle() && this.setDimensions) {
            String mainTitle = this.getTitle();
            screen.renderScrollingString(mainTitle, this.titleLeft + screen.getStringWidth(mainTitle) / 2, this.titleLeft, this.getTop(), this.titleRight, this.getBottom(), 0xFFFFFF);
        }
        super.draw(screen);
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.hasTitle() && this.setDimensions && screen.isOverScreen() && RenderUtils.isMouseOver(screen.getMouseX(), screen.getMouseY(), this.titleLeft, this.getTop(), this.titleRight - this.titleLeft, this.getControlHeight())) {
            this.onTitleHover();
        }
        super.postDraw(screen);
    }

    @Override
    public int getBottom() {
        return DynamicWidget$jvmdg$StaticDefaults.getBottom(this);
    }

    @Override
    public int getTop() {
        return DynamicWidget$jvmdg$StaticDefaults.getTop(this);
    }

    @Override
    public int getLeft() {
        return DynamicWidget$jvmdg$StaticDefaults.getLeft(this);
    }

    @Override
    public int getRight() {
        return DynamicWidget$jvmdg$StaticDefaults.getRight(this);
    }
}

