/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Phase.class})
public class ExtendedScreen
extends apn {
    private static final int DEFAULT_ELEMENT_PADDING = 5;
    private static final int DEFAULT_ELEMENT_HEIGHT = 20;
    private static int lastIndex = 0;
    private final apn currentScreen;
    private final List<aox> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<app> extendedLists = StringUtils.newArrayList();
    private String title;
    private String subTitle;
    private apn parentScreen;
    private Phase currentPhase = Phase.PREINIT;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private float lastPartialTicks = 0.0f;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;
    private boolean canModifyControls;
    private boolean focused;
    private int prevEventButton = 0;
    private long prevMouseEvent = 0L;
    private final List<aoh> restoreButtons = StringUtils.newArrayList();

    public ExtendedScreen(apn parentScreen, String title, String subTitle) {
        this.setGameInstance(ModUtils.getMinecraft());
        this.setParent(parentScreen);
        this.currentScreen = this;
        this.setScreenTitle(title);
        this.setScreenSubTitle(subTitle);
        this.setCanClose(true);
        this.setCanModifyControls(true);
        this.setContentHeight(0);
        this.setScreenSettings();
    }

    public ExtendedScreen(apn parentScreen, String title) {
        this(parentScreen, title, null);
    }

    public ExtendedScreen(apn parentScreen) {
        this(parentScreen, null);
    }

    public ExtendedScreen(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public ExtendedScreen(String title) {
        this(title, null);
    }

    public ExtendedScreen() {
        this((apn)null);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(String input) {
        ExtendedScreen.d((String)StringUtils.normalize(input));
    }

    public static int getProtocol() {
        return ModUtils.MCProtocolID;
    }

    public static int getKeyByVersion(int lwjgl2Key, int lwjgl3Key) {
        return ExtendedScreen.getProtocol() > 340 ? lwjgl3Key : lwjgl2Key;
    }

    public static boolean isEscapeKey(int keyCode) {
        return keyCode == ExtendedScreen.getKeyByVersion(1, 256);
    }

    public static void enableRepeatEvents(boolean enable) {
        Keyboard.enableRepeatEvents((boolean)enable);
    }

    public static long getSystemTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void w_() {
        if (!this.restoreButtons.isEmpty()) {
            this.h.clear();
            this.h.addAll(this.restoreButtons);
            this.restoreButtons.clear();
        }
        super.w_();
        this.clearData();
        ExtendedScreen.enableRepeatEvents(true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (!this.isUnloaded()) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.h.clear();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.isUnloaded()) {
            this.restoreButtons.addAll(this.h);
            this.a(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
            return;
        }
        if (this.isInitializing()) {
            this.resetMouseScroll();
            this.constructElements();
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.initializeUi();
            }
            this.appendElements();
            this.refreshContentHeight();
        }
    }

    public void constructElements() {
    }

    public void appendElements() {
    }

    public void reloadUi() {
        this.a(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void a(@Nonnull Minecraft mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.a(mcIn, w, h);
            }
        }
        super.a(mcIn, w, h);
    }

    @Nonnull
    public <T extends aox> T addControl(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof DynamicWidget) {
            DynamicWidget widget = (DynamicWidget)buttonIn;
            if (!this.extendedWidgets.contains(buttonIn)) {
                this.addWidget(widget);
            }
        }
        if (buttonIn instanceof aoh) {
            aoh button = (aoh)buttonIn;
            if (!this.h.contains(buttonIn)) {
                this.h.add(button);
            }
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends app> T addList(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, double u, double v, ScreenConstants.ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.startColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.endColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.texLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, data.colorLevel(), startColor, endColor);
        } else {
            Tuple<Boolean, String, String> textureData = RenderUtils.getTextureData(this.getGameInstance(), data.texLocation());
            boolean usingExternalTexture = textureData.getFirst();
            String texLocation = textureData.getThird();
            this.drawTexture(left, right, top, bottom, data.texLevel(), data.useFullTexture(), usingExternalTexture, offset, u, v, data.textureWidth(), data.textureHeight(), startColor, endColor, texLocation);
        }
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ScreenConstants.ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, left, top, data);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, String texLocation) {
        RenderUtils.drawTexture(this.getGameInstance(), left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, right - left, bottom - top, u, v + offset, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, String texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, offset, u, v, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, String texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, true, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, String texLocation) {
        this.drawTexture(left, right, top, bottom, 0.0, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public boolean hasWorld() {
        return WorldUtils.getWorld(this.getGameInstance()) != null;
    }

    public String getScreenTitle() {
        return this.title;
    }

    public void setScreenTitle(String title) {
        this.title = title;
    }

    public String getScreenSubTitle() {
        return this.subTitle;
    }

    public void setScreenSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ScreenConstants.ColorData getScreenBackground() {
        return this.hasWorld() ? ScreenConstants.DEFAULT_ALT_SCREEN_BACKGROUND : ScreenConstants.DEFAULT_SCREEN_BACKGROUND;
    }

    public ScreenConstants.TooltipData getTooltipData(boolean isTooltip) {
        return isTooltip ? ScreenConstants.getDefaultTooltip() : ScreenConstants.getEmptyTooltip();
    }

    public ScreenConstants.TooltipData getTooltipData() {
        return this.getTooltipData(true);
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        this.renderStringData();
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void renderStringData() {
        this.renderTitles(this.getScreenTitle(), this.getScreenSubTitle());
    }

    public void renderTitles(String title, String subTitle) {
        boolean hasSubTitle;
        boolean hasMainTitle = !StringUtils.isNullOrEmpty(title);
        boolean bl = hasSubTitle = !StringUtils.isNullOrEmpty(subTitle);
        if (hasMainTitle) {
            if (hasSubTitle) {
                this.renderScrollingString(title, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
                this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
            } else {
                this.renderScrollingString(title, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
            }
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void b(int tint) {
        this.renderCriticalData();
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        if (this.isLoaded()) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastPartialTicks = partialTicks;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            this.preRender();
            RenderUtils.enableScissor(this.getGameInstance(), this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            this.v_();
            for (app listControl : this.getLists()) {
                listControl.a(mouseX, mouseY, partialTicks);
            }
            super.a(mouseX, mouseY, partialTicks);
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.f();
            }
            this.renderExtra();
            RenderUtils.disableScissor(this.getGameInstance());
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.a(mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public void d() {
        if (this.isLoaded()) {
            this.setMouseScroll(Mouse.getEventDWheel());
            int dw = this.getMouseScroll();
            if (dw != 0) {
                this.mouseScrolled(this.getMouseX(), this.getMouseY(), (int)((double)dw / 60.0));
            }
            int mouseX = Mouse.getEventX() * this.getScreenWidth() / this.getGameInstance().c;
            int mouseY = this.getScreenHeight() - Mouse.getEventY() * this.getScreenHeight() / this.getGameInstance().d - 1;
            int eventButton = Mouse.getEventButton();
            if (Mouse.getEventButtonState()) {
                this.prevEventButton = eventButton;
                this.prevMouseEvent = ExtendedScreen.getSystemTime();
                this.a(mouseX, mouseY, this.prevEventButton);
            } else if (eventButton != -1) {
                this.prevEventButton = -1;
                this.b(mouseX, mouseY, eventButton);
            } else if (this.prevEventButton != -1 && this.prevMouseEvent > 0L) {
                long timeSinceLastClick = ExtendedScreen.getSystemTime() - this.prevMouseEvent;
                this.method_4259(mouseX, mouseY, this.prevEventButton, timeSinceLastClick);
            }
        }
    }

    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.mouseScrolled(mouseX, mouseY, wheelY);
            }
        }
    }

    protected void a(@Nonnull aoh button) {
        if (this.isOverScreen()) {
            if (button instanceof ExtendedButtonControl) {
                ExtendedButtonControl extendedButton = (ExtendedButtonControl)button;
                extendedButton.onClick();
            }
            super.a(button);
        }
    }

    protected void a(char typedChar, int keyCode) {
        if (this.isLoaded()) {
            if (this.isCurrentScreen() && ExtendedScreen.isEscapeKey(keyCode) && this.canClose()) {
                this.openScreen(this.getParent());
                return;
            }
            for (aox extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.a(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.a(typedChar, keyCode);
            }
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.a(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.a(mouseX, mouseY, mouseButton);
            }
            super.a(mouseX, mouseY, mouseButton);
        }
    }

    protected void method_4259(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.method_4259(mouseX, mouseY, mouseButton, timeSinceLastClick);
            }
        }
    }

    protected void b(int mouseX, int mouseY, int state) {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.b(mouseX, mouseY, state);
            }
            super.b(mouseX, mouseY, state);
        }
    }

    public void c() {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.a();
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.c();
            }
            super.c();
        }
    }

    public void b() {
        if (this.isLoaded()) {
            for (aox extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.b();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            ExtendedScreen.enableRepeatEvents(false);
        }
    }

    public Minecraft getGameInstance() {
        return this.e;
    }

    public void setGameInstance(Minecraft instance) {
        this.e = instance;
    }

    public void openScreen(apn targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public void openScreen(ExtendedScreen targetScreen, apn parentScreen, boolean setParent) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen, setParent);
    }

    public void openScreen(ExtendedScreen targetScreen, apn parentScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen);
    }

    public void openScreen(ExtendedScreen targetScreen) {
        this.openScreen(targetScreen, this.getInstance());
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        int topPosition = this.getTop();
        apn apn2 = this.getInstance();
        if (apn2 instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)apn2;
            topPosition += pane.getPadding();
        }
        return topPosition + 5 * (order + 1) + 20 * order;
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, isCentered, isTooltip, this.getTooltipData(isTooltip));
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderScrollingString(String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, float minX, float minY, float maxX, float maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int minX, int minY, int maxX, int maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, int yPos, int color) {
        this.renderCenteredString(text, this.getScreenWidth() / 2, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.renderString(text, Math.round(xPos), Math.round(yPos), color);
    }

    public void renderString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public int getStringWidth(String string) {
        return RenderUtils.getStringWidth(this.getFontRenderer(), string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public float getPartialTicks() {
        return this.lastPartialTicks;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public boolean isCurrentScreen() {
        return GameUtils.getCurrentScreen(this.getGameInstance()) == this;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public void setScreenSettings() {
    }

    public int getScreenWidth() {
        return this.f;
    }

    public void setScreenWidth(int screenWidth) {
        this.f = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
        for (aox extendedControl : this.getControls()) {
            if (!(extendedControl instanceof ExtendedScreen)) continue;
            ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
            extendedScreen.refreshContentHeight();
        }
    }

    public int getScreenHeight() {
        return this.g;
    }

    public void setScreenHeight(int screenHeight) {
        this.g = screenHeight;
    }

    public aov getFontRenderer() {
        return StringUtils.getOrDefault(this.getGameInstance().p, RenderUtils.getDefaultFontRenderer());
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public apn getInstance() {
        return this.currentScreen;
    }

    public apn getParent() {
        return this.parentScreen;
    }

    public void setParent(apn parentScreen) {
        this.parentScreen = parentScreen;
    }

    public boolean canClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean canModifyControls() {
        return this.canModifyControls;
    }

    public void setCanModifyControls(boolean canModifyControls) {
        this.canModifyControls = canModifyControls;
    }

    public void setFocused(boolean hasFocusedControlIn) {
        this.focused = hasFocusedControlIn;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public List<aox> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<app> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public boolean isInitializing() {
        return this.currentPhase == Phase.INIT;
    }

    public boolean isUnloaded() {
        return this.currentPhase == Phase.PREINIT;
    }

    @NestHost(value=ExtendedScreen.class)
    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

