/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class SubImageOutputStream
extends ImageOutputStreamImpl {
    private final ImageOutputStream stream;
    private final long startPos;

    public SubImageOutputStream(ImageOutputStream imageOutputStream) throws IOException {
        this.stream = Validate.notNull(imageOutputStream, "stream");
        this.startPos = imageOutputStream.getStreamPosition();
    }

    @Override
    public void seek(long l2) throws IOException {
        super.seek(l2);
        this.stream.seek(this.startPos + l2);
    }

    @Override
    public void write(int n2) throws IOException {
        this.flushBits();
        this.stream.write(n2);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.flushBits();
        this.stream.write(byArray, n2, n3);
        this.streamPos += (long)n3;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        ++this.streamPos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.bitOffset = 0;
        int n4 = this.stream.read(byArray, n2, n3);
        this.streamPos += (long)n4;
        return n4;
    }

    @Override
    public boolean isCached() {
        return this.stream.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.stream.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.stream.isCachedFile();
    }
}

