/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import unilib.external.com.twelvemonkeys.io.AbstractCachedSeekableStream;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class FileCacheSeekableStream
extends AbstractCachedSeekableStream {
    private byte[] buffer = new byte[1024];

    public FileCacheSeekableStream(InputStream inputStream) throws IOException {
        this(inputStream, "iocache", null);
    }

    public FileCacheSeekableStream(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, null);
    }

    public FileCacheSeekableStream(InputStream inputStream, String string, File file) throws IOException {
        this(Validate.notNull(inputStream, "stream"), FileCacheSeekableStream.createTempFile(string, file));
    }

    static File createTempFile(String string, File file) throws IOException {
        Validate.notNull(string, "tempBaseName");
        File file2 = File.createTempFile(string, null, file);
        file2.deleteOnExit();
        return file2;
    }

    FileCacheSeekableStream(InputStream inputStream, File file) throws FileNotFoundException {
        super(inputStream, new FileCache(file));
    }

    @Override
    public final boolean isCachedMemory() {
        return false;
    }

    @Override
    public final boolean isCachedFile() {
        return true;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.buffer = null;
    }

    @Override
    public int read() throws IOException {
        int n2;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n2 = this.readAhead(this.buffer, 0, this.buffer.length);
            if (n2 >= 0) {
                n2 = this.buffer[0] & 0xFF;
            }
        } else {
            this.syncPosition();
            n2 = this.getCache().read();
        }
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n4 = this.readAhead(byArray, n2, n3);
        } else {
            this.syncPosition();
            n4 = this.getCache().read(byArray, n2, (int)Math.min((long)n3, this.streamPosition - this.position));
        }
        if (n4 > 0) {
            this.position += (long)n4;
        }
        return n4;
    }

    private int readAhead(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.stream.read(byArray, n2, n3);
        if (n4 > 0) {
            this.streamPosition += (long)n4;
            this.getCache().write(byArray, n2, n4);
        }
        return n4;
    }

    static final class FileCache
    extends AbstractCachedSeekableStream.StreamCache {
        private RandomAccessFile cacheFile;

        public FileCache(File file) throws FileNotFoundException {
            Validate.notNull(file, "file");
            this.cacheFile = new RandomAccessFile(file, "rw");
        }

        @Override
        public void write(int n2) throws IOException {
            this.cacheFile.write(n2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.cacheFile.write(byArray, n2, n3);
        }

        @Override
        public int read() throws IOException {
            return this.cacheFile.read();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.cacheFile.read(byArray, n2, n3);
        }

        @Override
        public void seek(long l2) throws IOException {
            this.cacheFile.seek(l2);
        }

        @Override
        public long getPosition() throws IOException {
            return this.cacheFile.getFilePointer();
        }

        @Override
        void close() throws IOException {
            this.cacheFile.close();
        }
    }
}

