/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import unilib.external.com.twelvemonkeys.io.SeekableInputStream;

public final class FileSeekableStream
extends SeekableInputStream {
    final RandomAccessFile mRandomAccess;

    public FileSeekableStream(File file) throws FileNotFoundException {
        this(new RandomAccessFile(file, "r"));
    }

    public FileSeekableStream(RandomAccessFile randomAccessFile) {
        this.mRandomAccess = randomAccessFile;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public int available() throws IOException {
        long l2 = this.mRandomAccess.length() - this.position;
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    @Override
    public void closeImpl() throws IOException {
        this.mRandomAccess.close();
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int n2 = this.mRandomAccess.read();
        if (n2 >= 0) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkOpen();
        int n4 = this.mRandomAccess.read(byArray, n2, n3);
        if (n4 > 0) {
            this.position += (long)n4;
        }
        return n4;
    }

    @Override
    protected void flushBeforeImpl(long l2) {
    }

    @Override
    protected void seekImpl(long l2) throws IOException {
        this.mRandomAccess.seek(l2);
    }
}

