/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;
import unilib.external.com.twelvemonkeys.io.FileUtil;

public class LittleEndianRandomAccessFile
implements DataInput,
DataOutput {
    private RandomAccessFile file;

    public LittleEndianRandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(FileUtil.resolve(string), string2);
    }

    public LittleEndianRandomAccessFile(File file, String string) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, string);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public FileChannel getChannel() {
        return this.file.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.file.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.file.read(byArray);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.file.read(byArray, n2, n3);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.file.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.file.readFully(byArray, n2, n3);
    }

    @Override
    public String readLine() throws IOException {
        return this.file.readLine();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n2 = this.file.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n2 = this.file.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n2 = this.file.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public short readShort() throws IOException {
        int n2 = this.file.read();
        int n3 = this.file.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 24 >>> 16) + (n2 << 24) >>> 24);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n2 = this.file.read();
        int n3 = this.file.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    @Override
    public char readChar() throws IOException {
        int n2 = this.file.read();
        int n3 = this.file.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 24 >>> 16) + (n2 << 24 >>> 24));
    }

    @Override
    public int readInt() throws IOException {
        int n2 = this.file.read();
        int n3 = this.file.read();
        int n4 = this.file.read();
        int n5 = this.file.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 24 >>> 8) + (n3 << 24 >>> 16) + (n2 << 24 >>> 24);
    }

    @Override
    public long readLong() throws IOException {
        long l2 = this.file.read();
        long l3 = this.file.read();
        long l4 = this.file.read();
        long l5 = this.file.read();
        long l6 = this.file.read();
        long l7 = this.file.read();
        long l8 = this.file.read();
        long l9 = this.file.read();
        if (l9 < 0L) {
            throw new EOFException();
        }
        return (l9 << 56) + (l8 << 56 >>> 8) + (l7 << 56 >>> 16) + (l6 << 56 >>> 24) + (l5 << 56 >>> 32) + (l4 << 56 >>> 40) + (l3 << 56 >>> 48) + (l2 << 56 >>> 56);
    }

    @Override
    public String readUTF() throws IOException {
        int n2 = this.file.read();
        int n3 = this.file.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        int n4 = (n2 << 8) + n3;
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8 = this.readUnsignedByte();
            int n9 = n8 >> 4;
            if (n9 < 8) {
                ++n5;
                cArray[n6++] = (char)n8;
                continue;
            }
            if (n9 == 12 || n9 == 13) {
                if ((n5 += 2) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = this.readUnsignedByte();
                if ((n7 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0x1F) << 6 | n7 & 0x3F);
                continue;
            }
            if (n9 == 14) {
                if ((n5 += 3) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = this.readUnsignedByte();
                int n10 = this.readUnsignedByte();
                if ((n7 & 0xC0) != 128 || (n10 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0xF) << 12 | (n7 & 0x3F) << 6 | n10 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n6);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void seek(long l2) throws IOException {
        this.file.seek(l2);
    }

    public void setLength(long l2) throws IOException {
        this.file.setLength(l2);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return this.file.skipBytes(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.file.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.file.write(byArray, n2, n3);
    }

    @Override
    public void write(int n2) throws IOException {
        this.file.write(n2);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.file.write(n2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.file.write(n2 & 0xFF);
        this.file.write(n2 >>> 8 & 0xFF);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.file.write(n2 & 0xFF);
        this.file.write(n2 >>> 8 & 0xFF);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.file.write(n2 & 0xFF);
        this.file.write(n2 >>> 8 & 0xFF);
        this.file.write(n2 >>> 16 & 0xFF);
        this.file.write(n2 >>> 24 & 0xFF);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.file.write((int)l2 & 0xFF);
        this.file.write((int)(l2 >>> 8) & 0xFF);
        this.file.write((int)(l2 >>> 16) & 0xFF);
        this.file.write((int)(l2 >>> 24) & 0xFF);
        this.file.write((int)(l2 >>> 32) & 0xFF);
        this.file.write((int)(l2 >>> 40) & 0xFF);
        this.file.write((int)(l2 >>> 48) & 0xFF);
        this.file.write((int)(l2 >>> 56) & 0xFF);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            this.file.write((byte)string.charAt(i));
        }
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            this.file.write(c & 0xFF);
            this.file.write(c >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 > 65535) {
            throw new UTFDataFormatException();
        }
        this.file.write(n4 >>> 8 & 0xFF);
        this.file.write(n4 & 0xFF);
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                this.file.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.file.write(0xE0 | c >> 12 & 0xF);
                this.file.write(0x80 | c >> 6 & 0x3F);
                this.file.write(0x80 | c & 0x3F);
                continue;
            }
            this.file.write(0xC0 | c >> 6 & 0x1F);
            this.file.write(0x80 | c & 0x3F);
        }
    }
}

