/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;

public class WorldUtils {
    public static Level getWorld(Minecraft client) {
        return client != null ? client.level : null;
    }

    public static Level getWorld(Entity entity) {
        return entity != null ? entity.level() : null;
    }

    public static Player getPlayer(Minecraft client) {
        return client != null ? client.player : null;
    }

    public static String getEntityName(Entity entity, boolean stripFormatting) {
        String result = "";
        if (entity != null) {
            result = StringUtils.getOrDefault(entity.getDisplayName().getString(), entity.getName().getString());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getEntityName(Entity entity) {
        return WorldUtils.getEntityName(entity, true);
    }

    public static String getWeather(Level world) {
        String name = "clear";
        if (world != null) {
            LevelData info = world.getLevelData();
            name = info.isThundering() ? "thunder" : (info.isRaining() ? "rain" : "clear");
        }
        return name;
    }

    public static String getWeather(Entity entity) {
        return WorldUtils.getWeather(WorldUtils.getWorld(entity));
    }
}

