/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import com.gitlab.cdagaming.unilib.utils.ImageUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final WidgetSprites DEFAULT_BUTTON_SPRITES = new WidgetSprites(ResourceUtils.getResource("widget/button"), ResourceUtils.getResource("widget/button_disabled"), ResourceUtils.getResource("widget/button_highlighted"));
    private static final List<ItemStack> BLOCKED_RENDER_ITEMS = StringUtils.newArrayList();
    private static final Map<String, Tuple<Boolean, String, ResourceLocation>> TEXTURE_CACHE = StringUtils.newHashMap();

    public static ResourceLocation getScreenTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultGUIBackground()).getThird();
    }

    public static ResourceLocation getAltScreenTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultGUIBackgroundAlt()).getThird();
    }

    public static ResourceLocation getWorldScreenTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultWorldGUIBackground()).getThird();
    }

    public static ResourceLocation getAltWorldScreenTexture(@Nonnull Minecraft mc) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultWorldGUIBackgroundAlt()).getThird();
    }

    public static ResourceLocation getButtonTexture(boolean enabled, boolean hoverState) {
        return DEFAULT_BUTTON_SPRITES.get(enabled, hoverState);
    }

    public static boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return MathUtils.isWithinValue(mouseY, topIn, bottomIn, true, true) && MathUtils.isWithinValue(mouseX, leftIn, rightIn, true, true);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return MathUtils.isWithinValue(mouseX, elementX, elementX + elementWidth, true, false) && MathUtils.isWithinValue(mouseY, elementY, elementY + elementHeight, true, false);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, DynamicWidget widget) {
        return RenderUtils.isMouseOver(mouseX, mouseY, widget.getControlPosX(), widget.getControlPosY(), widget.getControlWidth() - 1, widget.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)button);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return textControl.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)textControl);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedScreen screen) {
        return screen.isLoaded() && RenderUtils.isMouseOver(mouseX, mouseY, screen.getScreenX(), screen.getScreenY(), screen.getScreenWidth(), screen.getScreenHeight());
    }

    public static boolean isMouseOver(ExtendedScreen screen) {
        return RenderUtils.isMouseOver((double)screen.getMouseX(), (double)screen.getMouseY(), screen);
    }

    public static Font getDefaultFontRenderer() {
        return ModUtils.getMinecraft().font;
    }

    public static void openScreen(@Nonnull Minecraft client, Screen targetScreen) {
        ModUtils.executeOnMainThread(client, () -> client.setScreen(targetScreen));
    }

    public static void openScreen(@Nonnull Minecraft client, ExtendedScreen targetScreen, Screen parentScreen, boolean setParent) {
        if (setParent) {
            targetScreen.setParent(parentScreen);
        }
        RenderUtils.openScreen(client, targetScreen);
    }

    public static void openScreen(@Nonnull Minecraft client, ExtendedScreen targetScreen, Screen parentScreen) {
        RenderUtils.openScreen(client, targetScreen, parentScreen, targetScreen.getParent() == null);
    }

    public static void drawItemStack(@Nonnull GuiGraphics client, Font fontRenderer, int x, int y, ItemStack stack, float scale) {
        block3: {
            if (BLOCKED_RENDER_ITEMS.contains(stack)) {
                return;
            }
            try {
                PoseStack lv = client.pose();
                lv.pushPose();
                lv.scale(scale, scale, 1.0f);
                int xPos = Math.round((float)x / scale);
                int yPos = Math.round((float)y / scale);
                client.renderItem(stack, xPos, yPos);
                client.renderItemDecorations(fontRenderer, stack, xPos, yPos);
                lv.popPose();
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                if (BLOCKED_RENDER_ITEMS.contains(stack)) break block3;
                BLOCKED_RENDER_ITEMS.add(stack);
            }
        }
    }

    public static void drawGradientBox(@Nonnull GuiGraphics mc, RenderType renderType, double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        double canvasWidth = width - (double)(border * 2);
        double canvasHeight = height - (double)(border * 2);
        double canvasRight = posX + (double)border + canvasWidth;
        double canvasBottom = posY + (double)border + canvasHeight;
        if (borderColor != null) {
            RenderUtils.drawGradient(mc, renderType, posX, posX + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(mc, renderType, canvasRight, canvasRight + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(mc, renderType, posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, canvasBottom, canvasBottom + (double)border, zLevel, borderColorEnd, borderColorEnd);
            RenderUtils.drawGradient(mc, renderType, posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, posY, posY + (double)border, zLevel, borderColor, borderColor);
        }
        if (contentColor != null) {
            RenderUtils.drawGradient(mc, renderType, posX + (double)border, canvasRight, posY + (double)border, canvasBottom, zLevel, contentColor, contentColorEnd);
        }
    }

    public static void drawGradientBox(@Nonnull GuiGraphics mc, double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(mc, RenderType.gui(), posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, borderOffset, contentColor, contentColorEnd);
    }

    public static void drawGradientBox(@Nonnull GuiGraphics mc, RenderType renderType, double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(mc, renderType, posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, 0, contentColor, contentColorEnd);
    }

    public static void drawGradientBox(@Nonnull GuiGraphics mc, double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(mc, RenderType.gui(), posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, contentColor, contentColorEnd);
    }

    public static void renderSprite(@Nonnull GuiGraphics graphics, Consumer<GuiGraphics> callback) {
        callback.accept(graphics);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        if (!asFullTexture) {
            RenderUtils.drawGradient(matrixStack, left, right, top, bottom, zLevel, startColorObj, endColorObj);
            return;
        }
        if (!ResourceUtils.isValidResource(texLocation)) {
            return;
        }
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        matrixStack.drawSpecial(bufferSource -> {
            Matrix4f matrix4f = matrixStack.pose().last().pose();
            VertexConsumer buffer = bufferSource.getBuffer((RenderType)function.apply(texLocation));
            buffer.addVertex(matrix4f, (float)left, (float)bottom, (float)zLevel).setUv((float)minU, (float)maxV).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
            buffer.addVertex(matrix4f, (float)right, (float)bottom, (float)zLevel).setUv((float)maxU, (float)maxV).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
            buffer.addVertex(matrix4f, (float)right, (float)top, (float)zLevel).setUv((float)maxU, (float)minV).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
            buffer.addVertex(matrix4f, (float)left, (float)top, (float)zLevel).setUv((float)minU, (float)minV).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        });
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, asFullTexture, minU, maxU, minV, maxV, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, function, left, right, top, bottom, zLevel, true, minU, maxU, minV, maxV, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, minU, maxU, minV, maxV, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, function, left, right, top, bottom, zLevel, asFullTexture, RenderUtils.getUVCoord(u + 0.0, 0.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(u + regionWidth, 1.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(v + 0.0, 0.0, usingExternalTexture, textureHeight), RenderUtils.getUVCoord(v + regionHeight, 1.0, usingExternalTexture, textureHeight), startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, regionWidth, regionHeight, u, v, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, function, left, right, top, bottom, zLevel, true, usingExternalTexture, regionWidth, regionHeight, u, v, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, usingExternalTexture, regionWidth, regionHeight, u, v, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, function, left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, right - left, bottom - top, left, top, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, Function<ResourceLocation, RenderType> function, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, function, left, right, top, bottom, zLevel, true, usingExternalTexture, startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(mc, matrixStack, RenderType::guiTextured, left, right, top, bottom, zLevel, usingExternalTexture, startColorObj, endColorObj, texLocation);
    }

    public static void drawGradient(@Nonnull GuiGraphics mc, RenderType renderType, double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        mc.drawSpecial(bufferSource -> {
            Matrix4f matrix4f = mc.pose().last().pose();
            VertexConsumer buffer = bufferSource.getBuffer(renderType);
            buffer.addVertex(matrix4f, (float)left, (float)bottom, (float)zLevel).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
            buffer.addVertex(matrix4f, (float)right, (float)bottom, (float)zLevel).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
            buffer.addVertex(matrix4f, (float)right, (float)top, (float)zLevel).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
            buffer.addVertex(matrix4f, (float)left, (float)top, (float)zLevel).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        });
    }

    public static void drawGradient(@Nonnull GuiGraphics mc, double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        RenderUtils.drawGradient(mc, RenderType.gui(), left, right, top, bottom, zLevel, startColorObj, endColorObj);
    }

    public static void blit(@Nonnull GuiGraphics mc, Function<ResourceLocation, RenderType> function, ResourceLocation texLocation, double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(mc, function, texLocation, xPos, yPos, zLevel, u, v, regionWidth, regionHeight, 256.0, 256.0);
    }

    public static void blit(@Nonnull GuiGraphics mc, ResourceLocation texLocation, double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(mc, RenderType::guiTextured, texLocation, xPos, yPos, zLevel, u, v, regionWidth, regionHeight);
    }

    public static void blit(@Nonnull GuiGraphics mc, Function<ResourceLocation, RenderType> function, ResourceLocation texLocation, double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.blit(mc, function, texLocation, xPos, xPos + regionWidth, yPos, yPos + regionHeight, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(@Nonnull GuiGraphics mc, ResourceLocation texLocation, double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.blit(mc, RenderType::guiTextured, texLocation, xPos, yPos, zLevel, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static void blit(@Nonnull GuiGraphics mc, Function<ResourceLocation, RenderType> function, ResourceLocation texLocation, double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(mc, function, texLocation, left, right, top, bottom, zLevel, RenderUtils.getUVCoord(u + 0.0, textureWidth), RenderUtils.getUVCoord(u + regionWidth, textureWidth), RenderUtils.getUVCoord(v + 0.0, textureHeight), RenderUtils.getUVCoord(v + regionHeight, textureHeight));
    }

    public static void blit(@Nonnull GuiGraphics mc, ResourceLocation texLocation, double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.blit(mc, RenderType::guiTextured, texLocation, left, right, top, bottom, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void innerBlit(@Nonnull GuiGraphics mc, Function<ResourceLocation, RenderType> function, ResourceLocation texLocation, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        mc.drawSpecial(bufferSource -> {
            Matrix4f matrix4f = mc.pose().last().pose();
            VertexConsumer buffer = bufferSource.getBuffer((RenderType)function.apply(texLocation));
            buffer.addVertex(matrix4f, (float)left, (float)bottom, (float)zLevel).setUv((float)minU, (float)maxV);
            buffer.addVertex(matrix4f, (float)right, (float)bottom, (float)zLevel).setUv((float)maxU, (float)maxV);
            buffer.addVertex(matrix4f, (float)right, (float)top, (float)zLevel).setUv((float)maxU, (float)minV);
            buffer.addVertex(matrix4f, (float)left, (float)top, (float)zLevel).setUv((float)minU, (float)minV);
        });
    }

    public static void innerBlit(@Nonnull GuiGraphics mc, ResourceLocation texLocation, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        RenderUtils.innerBlit(mc, RenderType::guiTextured, texLocation, left, right, top, bottom, zLevel, minU, maxU, minV, maxV);
    }

    public static void enableScissor(@Nonnull GuiGraphics mc, int left, int top, int right, int bottom) {
        mc.enableScissor(left, top, right, bottom);
    }

    public static void disableScissor(@Nonnull GuiGraphics mc) {
        mc.disableScissor();
    }

    public static int computeGuiScale(@Nonnull Minecraft mc) {
        int scaleFactor = 1;
        int k = (Integer)mc.options.guiScale().get();
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.getWindow().getWidth() / (scaleFactor + 1) >= 320 && mc.getWindow().getHeight() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static Tuple<Boolean, String, ResourceLocation> getTextureData(@Nonnull Minecraft mc, String texture) {
        ResourceLocation texLocation = ResourceUtils.getEmptyResource();
        Tuple<Boolean, String, ResourceLocation> result = new Tuple<Boolean, String, ResourceLocation>(false, "", texLocation);
        if (!StringUtils.isNullOrEmpty(texture)) {
            if (TEXTURE_CACHE.containsKey(texture = texture.trim())) {
                return TEXTURE_CACHE.get(texture);
            }
        } else {
            return result;
        }
        boolean usingExternalTexture = false;
        if (!StringUtils.isValidColorCode(texture)) {
            usingExternalTexture = ImageFrame.isExternalImage(texture);
            if (!usingExternalTexture) {
                if (texture.startsWith(":")) {
                    texture = texture.substring(1);
                }
                if (texture.contains(":")) {
                    String[] splitInput = texture.split(":", 2);
                    texLocation = ResourceUtils.getResource(splitInput[0], splitInput[1]);
                } else {
                    texLocation = ResourceUtils.getResource(texture);
                }
            } else {
                String formattedConvertedName = texture.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.trim().split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                texLocation = ImageUtils.getTextureFromUrl(mc, textureName, texture.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
            }
        }
        result.put(usingExternalTexture, texture, texLocation);
        if (!usingExternalTexture) {
            TEXTURE_CACHE.put(texture, result);
        }
        return result;
    }

    public static void drawMultiLineString(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, Font fontRenderer, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        if (colorInfo.renderTooltips() && !textToInput.isEmpty() && fontRenderer != null) {
            boolean usingExternalTexture;
            Tuple<Boolean, String, ResourceLocation> textureData;
            List<String> textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = RenderUtils.getStringWidth(fontRenderer, textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean allowXAdjustments = maxWidth > 0;
            boolean allowYAdjustments = maxHeight > 0;
            boolean allowCenterAdjustments = isCentered && allowXAdjustments;
            int titleLinesCount = 1;
            int tooltipX = posX;
            if (!isTooltip && allowCenterAdjustments) {
                tooltipX = posX + 4;
                tooltipTextWidth = maxWidth - tooltipX - 4;
            } else if (isTooltip) {
                tooltipX = posX + (allowXAdjustments ? 12 : 0);
                if (allowXAdjustments && tooltipX + tooltipTextWidth + 4 > maxWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = posX > maxWidth / 2 ? posX - 12 - 8 : maxWidth - 16 - posX;
                    needsWrap = true;
                }
                if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                    tooltipTextWidth = maxTextWidth;
                    needsWrap = true;
                }
            }
            if (needsWrap) {
                List wrappedTextLines = StringUtils.newArrayList();
                int wrappedTooltipWidth = 0;
                for (int i = 0; i < textLines.size(); ++i) {
                    List<String> wrappedLine = RenderUtils.listFormattedStringToWidth(fontRenderer, textLines.get(i), tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                if (allowXAdjustments) {
                    tooltipX = posX > maxWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
                }
            }
            int tooltipY = posY - (isTooltip && allowYAdjustments ? 12 : 0);
            int tooltipHeight = 8;
            int fontHeight = RenderUtils.getFontHeight(fontRenderer);
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * (fontHeight + 1);
                if (isTooltip && textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (allowYAdjustments) {
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > maxHeight) {
                    tooltipY = maxHeight - tooltipHeight - 4;
                }
            }
            ScreenConstants.ColorData backgroundColorInfo = colorInfo.backgroundColor();
            ScreenConstants.ColorData borderColorInfo = colorInfo.borderColor();
            int zLevel = 400;
            if (backgroundColorInfo != null) {
                Color backgroundStart = backgroundColorInfo.startColor();
                Color backgroundEnd = backgroundColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(backgroundColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(matrixStack, tooltipX - 4, (double)(tooltipY - 4), (double)(tooltipTextWidth + 8), (double)(tooltipHeight + 8), 400.0, backgroundStart, (Object)backgroundEnd, 1, -1, (Object)backgroundStart, (Object)backgroundEnd);
                } else {
                    textureData = RenderUtils.getTextureData(mc, backgroundColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    ResourceLocation backGroundTexture = textureData.getThird();
                    double width = tooltipTextWidth + 4;
                    double height = tooltipHeight + 4;
                    double left = tooltipX - 4;
                    double right = (double)tooltipX + width;
                    double top = tooltipY - 4;
                    double bottom = (double)tooltipY + height;
                    RenderUtils.drawTexture(mc, matrixStack, left, right, top, bottom, 0.0, usingExternalTexture, backgroundStart, backgroundEnd, backGroundTexture);
                }
            }
            if (borderColorInfo != null) {
                Color borderStart = borderColorInfo.startColor();
                Color borderEnd = borderColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(borderColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(matrixStack, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 400.0, borderStart, borderEnd, 1, null, null);
                } else {
                    textureData = RenderUtils.getTextureData(mc, borderColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    ResourceLocation borderTexture = textureData.getThird();
                    double border = 1.0;
                    double renderX = tooltipX - 3;
                    double renderY = tooltipY - 3;
                    double canvasRight = tooltipX + tooltipTextWidth + 2;
                    double canvasBottom = tooltipY + tooltipHeight + 2;
                    RenderUtils.drawTexture(mc, matrixStack, renderX, renderX + 1.0, renderY, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, matrixStack, canvasRight, canvasRight + 1.0, renderY, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, matrixStack, renderX, canvasRight + 1.0, canvasBottom, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, matrixStack, renderX, canvasRight + 1.0, renderY, renderY + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                }
            }
            matrixStack.pose().pushPose();
            matrixStack.pose().translate(0.0, 0.0, 400.0);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                int renderX = isCentered ? tooltipX + (tooltipTextWidth - lineWidth) / 2 : tooltipX;
                RenderUtils.renderString(matrixStack, fontRenderer, line, renderX, tooltipY, -1);
                if (isTooltip && lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += fontHeight + 1;
            }
            matrixStack.pose().popPose();
        }
    }

    public static void renderCenteredString(@Nonnull GuiGraphics matrixStack, Font fontRenderer, String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, xPos - (float)RenderUtils.getStringWidth(fontRenderer, text) / 2.0f, yPos, color);
    }

    public static void renderCenteredString(@Nonnull GuiGraphics matrixStack, Font fontRenderer, String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, xPos - RenderUtils.getStringWidth(fontRenderer, text) / 2, yPos, color);
    }

    public static void renderString(@Nonnull GuiGraphics matrixStack, Font fontRenderer, String text, float xPos, float yPos, int color) {
        if (!StringUtils.isNullOrEmpty(text)) {
            matrixStack.drawSpecial(bufferSource -> fontRenderer.drawInBatch(text, xPos, yPos, color, true, matrixStack.pose().last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0));
        }
    }

    public static void renderString(@Nonnull GuiGraphics matrixStack, Font fontRenderer, String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, (float)xPos, (float)yPos, color);
    }

    public static int getStringWidth(Font fontRenderer, String string) {
        return fontRenderer.width(string);
    }

    public static int getFontHeight(Font fontRenderer) {
        Objects.requireNonNull(fontRenderer);
        return 9;
    }

    public static void renderScrollingString(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, Font fontRenderer, String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        float renderY = (minY + maxY - (float)RenderUtils.getFontHeight(fontRenderer)) / 2.0f + 1.0f;
        float elementWidth = maxX - minX;
        if ((float)lineWidth > elementWidth) {
            float renderWidth = (float)lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(matrixStack, (int)minX, (int)minY, (int)maxX, (int)maxY);
            RenderUtils.renderString(matrixStack, fontRenderer, message, minX - (float)offset, renderY, color);
            RenderUtils.disableScissor(matrixStack);
        } else {
            float renderX = MathUtils.clamp(centerX, minX + (float)lineWidth / 2.0f, maxX - (float)lineWidth / 2.0f);
            RenderUtils.renderCenteredString(matrixStack, fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, Font fontRenderer, String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        int renderY = (minY + maxY - RenderUtils.getFontHeight(fontRenderer)) / 2 + 1;
        int elementWidth = maxX - minX;
        if (lineWidth > elementWidth) {
            int renderWidth = lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(matrixStack, minX, minY, maxX, maxY);
            RenderUtils.renderString(matrixStack, fontRenderer, message, minX - (int)offset, renderY, color);
            RenderUtils.disableScissor(matrixStack);
        } else {
            int renderX = MathUtils.clamp(centerX, minX + lineWidth / 2, maxX - lineWidth / 2);
            RenderUtils.renderCenteredString(matrixStack, fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, Font fontRenderer, String message, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(matrixStack, mc, fontRenderer, message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, Font fontRenderer, String message, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(matrixStack, mc, fontRenderer, message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public static double getUVCoord(double primary, double secondary, boolean usingExternalTexture, double textureSize) {
        return usingExternalTexture ? secondary : RenderUtils.getUVCoord(primary, textureSize);
    }

    public static double getUVCoord(double primary, double textureSize) {
        return primary / textureSize;
    }

    public static List<String> listFormattedStringToWidth(Font fontRenderer, String stringInput, int wrapWidth) {
        List<String> result = StringUtils.newArrayList();
        fontRenderer.getSplitter().splitLines(stringInput, wrapWidth, Style.EMPTY).forEach(line -> result.add(line.getString()));
        return result;
    }
}

