/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.plugins.webp.lossless;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import unilib.external.com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;

final class HuffmanTable {
    private static final int LEVEL1_BITS = 8;
    private static final int[] L_CODE_ORDER = new int[]{17, 18, 0, 1, 2, 3, 4, 5, 16, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final int[] level1 = new int[256];
    private final List<int[]> level2 = new ArrayList<int[]>();

    public HuffmanTable(LSBBitReader lSBBitReader, int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = lSBBitReader.readBit() == 1;
        if (bl) {
            int n2 = lSBBitReader.readBit() + 1;
            boolean bl3 = lSBBitReader.readBit() == 1;
            short s = (short)lSBBitReader.readBits(bl3 ? 8 : 1);
            if (n2 == 2) {
                short s2 = (short)lSBBitReader.readBits(8);
                for (int i = 0; i < 256; i += 2) {
                    this.level1[i] = 0x10000 | s;
                    this.level1[i + 1] = 0x10000 | s2;
                }
            } else {
                Arrays.fill(this.level1, (int)s);
            }
        } else {
            int n3 = (int)(lSBBitReader.readBits(4) + 4L);
            short[] sArray = new short[L_CODE_ORDER.length];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                short s;
                sArray[HuffmanTable.L_CODE_ORDER[i]] = s = (short)lSBBitReader.readBits(3);
                if (s <= 0) continue;
                ++n4;
            }
            short[] sArray2 = HuffmanTable.readCodeLengths(lSBBitReader, sArray, n, n4);
            this.buildFromLengths(sArray2);
        }
    }

    private HuffmanTable(short[] sArray, int n) {
        this.buildFromLengths(sArray, n);
    }

    private void buildFromLengths(short[] sArray) {
        int n = 0;
        for (short s : sArray) {
            if (s == 0) continue;
            ++n;
        }
        this.buildFromLengths(sArray, n);
    }

    private void buildFromLengths(short[] sArray, int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = 0;
        for (n2 = 0; n2 < sArray.length; ++n2) {
            if (sArray[n2] == 0) continue;
            nArray[n3++] = sArray[n2] << 16 | n2;
        }
        if (n == 1) {
            Arrays.fill(this.level1, nArray[0] & 0xFFFF);
        }
        Arrays.sort(nArray);
        n2 = 0;
        int n4 = -1;
        int[] nArray2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            int n5;
            int n6 = nArray[i];
            int n7 = n6 >>> 16;
            if (n7 <= 8) {
                for (n5 = n2; n5 < this.level1.length; n5 += 1 << n7) {
                    this.level1[n5] = n6;
                }
            } else {
                if ((n2 & 0xFF) != n4) {
                    n5 = n7;
                    int n8 = i;
                    for (int j = 1 << n7 - 8; n8 < nArray.length && j > 0; ++n8, --j) {
                        int n9 = nArray[n8] >>> 16;
                        while (n9 != n5) {
                            ++n5;
                            j <<= 1;
                        }
                    }
                    n8 = n5 - 8;
                    nArray2 = new int[1 << n8];
                    n4 = n2 & 0xFF;
                    this.level2.add(nArray2);
                    this.level1[n4] = 8 + n8 << 16 | this.level2.size() - 1;
                }
                for (n5 = n2 >>> 8; n5 < nArray2.length; n5 += 1 << n7 - 8) {
                    nArray2[n5] = n7 - 8 << 16 | n6 & 0xFFFF;
                }
            }
            n2 = this.nextCode(n2, n7);
        }
    }

    private int nextCode(int n, int n2) {
        int n3 = ~n & (1 << n2) - 1;
        int n4 = Integer.highestOneBit(n3);
        return n & n4 - 1 | n4;
    }

    private static short[] readCodeLengths(LSBBitReader lSBBitReader, short[] sArray, int n, int n2) throws IOException {
        int n3;
        HuffmanTable huffmanTable = new HuffmanTable(sArray, n2);
        if (lSBBitReader.readBit() == 1) {
            int n4 = (int)(2L + 2L * lSBBitReader.readBits(3));
            n3 = (int)(2L + lSBBitReader.readBits(n4));
        } else {
            n3 = n;
        }
        short[] sArray2 = new short[n];
        short s = 8;
        for (int i = 0; i < n && n3 > 0; ++i, --n3) {
            int n5;
            int n6;
            short s2 = huffmanTable.readSymbol(lSBBitReader);
            if (s2 < 16) {
                sArray2[i] = s2;
                if (s2 == 0) continue;
                s = s2;
                continue;
            }
            short s3 = 0;
            switch (s2) {
                case 16: {
                    s3 = s;
                    n6 = 2;
                    n5 = 3;
                    break;
                }
                case 17: {
                    n6 = 3;
                    n5 = 3;
                    break;
                }
                case 18: {
                    n6 = 7;
                    n5 = 11;
                    break;
                }
                default: {
                    throw new IIOException("Huffman: Unreachable: Decoded Code Length > 18.");
                }
            }
            int n7 = (int)(lSBBitReader.readBits(n6) + (long)n5);
            if (i + n7 > n) {
                throw new IIOException(String.format("Huffman: Code length repeat count overflows alphabet: Start index: %d, count: %d, alphabet size: %d", i, n7, n));
            }
            Arrays.fill(sArray2, i, i + n7, s3);
            i += n7 - 1;
        }
        return sArray2;
    }

    public short readSymbol(LSBBitReader lSBBitReader) throws IOException {
        int n = (int)lSBBitReader.peekBits(8);
        int n2 = this.level1[n];
        int n3 = n2 >>> 16;
        if (n3 > 8) {
            lSBBitReader.readBits(8);
            int n4 = (int)lSBBitReader.peekBits(n3 - 8);
            n2 = this.level2.get(n2 & 0xFFFF)[n4];
            n3 = n2 >>> 16;
        }
        lSBBitReader.readBits(n3);
        return (short)(n2 & 0xFFFF);
    }
}

