/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io.enc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import unilib.external.com.twelvemonkeys.io.enc.Encoder;

public final class PackBitsEncoder
implements Encoder {
    private final byte[] buffer = new byte[128];

    @Override
    public void encode(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        this.encode(outputStream, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        byteBuffer.position(byteBuffer.remaining());
    }

    private void encode(OutputStream outputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        int n6 = n5 - 1;
        while (n4 <= n5) {
            int n7;
            byte by2 = byArray[n4];
            for (n7 = 1; n7 < 127 && n4 < n5 && byArray[n4] == byArray[n4 + 1]; ++n4, ++n7) {
            }
            if (n7 > 1) {
                ++n4;
                outputStream.write(-(n7 - 1));
                outputStream.write(by2);
            }
            n7 = 0;
            while (n7 < 128 && (n4 < n5 && byArray[n4] != byArray[n4 + 1] || n4 < n6 && byArray[n4] != byArray[n4 + 2])) {
                this.buffer[n7++] = byArray[n4++];
            }
            if (n4 == n5 && n7 > 0 && n7 < 128) {
                this.buffer[n7++] = byArray[n4++];
            }
            if (n7 > 0) {
                outputStream.write(n7 - 1);
                outputStream.write(this.buffer, 0, n7);
            }
            if (n4 != n5 || n7 > 0 && n7 < 128) continue;
            outputStream.write(0);
            outputStream.write(byArray[n4++]);
        }
    }
}

