/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.widgets;

import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.Supplier;

public class TexturedWidget
implements DynamicWidget {
    private int startX;
    private int startY;
    private int width;
    private int height;
    private double offset;
    private Supplier<Float> tintSupplier;
    private Supplier<ScreenConstants.ColorData> infoSupplier;
    private boolean hasBorder;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TexturedWidget(int startX, int startY, int width, int height, double offset, Supplier<Float> tintSupplier, Supplier<ScreenConstants.ColorData> infoSupplier, boolean hasBorder) {
        this.setControlPosX(startX);
        this.setControlPosY(startY);
        this.setControlWidth(width);
        this.setControlHeight(height);
        this.setOffset(offset);
        this.setTintSupplier(tintSupplier);
        this.setInfoSupplier(infoSupplier);
        this.setBorderState(hasBorder);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (!this.hasInfo()) {
            return;
        }
        if (this.hasBorder()) {
            RenderUtils.drawGradientBox(screen.getCurrentMatrix(), this.getControlPosX() - 1, this.getControlPosY() - 1, this.getControlWidth() + 2, this.getControlHeight() + 2, 300.0, "#000000", "#000000", 1, null, null);
        }
        screen.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), 0.0, 0.0, this.getInfo());
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public Supplier<Float> getTintSupplier() {
        return this.tintSupplier;
    }

    public void setTintSupplier(Supplier<Float> tintSupplier) {
        this.tintSupplier = tintSupplier;
    }

    public float getTintFactor() {
        return this.getTintSupplier().get().floatValue();
    }

    public Supplier<ScreenConstants.ColorData> getInfoSupplier() {
        return this.infoSupplier;
    }

    public void setInfoSupplier(Supplier<ScreenConstants.ColorData> infoSupplier) {
        this.infoSupplier = infoSupplier;
    }

    public ScreenConstants.ColorData getInfo() {
        return this.hasInfoSupplier() ? this.getInfoSupplier().get() : null;
    }

    public boolean hasInfoSupplier() {
        return this.getInfoSupplier() != null;
    }

    public boolean hasInfo() {
        return this.hasInfoSupplier() && this.getInfoSupplier().get() != null;
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setBorderState(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    @Override
    public int getControlPosX() {
        return this.startX;
    }

    @Override
    public void setControlPosX(int posX) {
        this.startX = posX;
    }

    @Override
    public int getControlPosY() {
        return this.startY;
    }

    @Override
    public void setControlPosY(int posY) {
        this.startY = posY;
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.height;
    }

    @Override
    public void setControlHeight(int height) {
        this.height = height;
    }
}

