/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.integrations.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.integrations.logging.LoggingImpl;
import io.github.cdagaming.unicore.utils.FileUtils;
import java.util.logging.Logger;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class LegacyLogger
extends LoggingImpl {
    private final Logger logInstance;
    boolean appendName;

    public LegacyLogger(String loggerName, boolean debug) {
        super(loggerName, debug);
        Logger logger = null;
        try {
            logger = (Logger)FileUtils.loadClass("net.minecraft.src.ModLoader", "ModLoader").getDeclaredMethod("getLogger", new Class[0]).invoke(null, new Object[0]);
            if (logger != null) {
                this.appendName = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logInstance = logger != null ? logger : Logger.getLogger(loggerName);
    }

    public LegacyLogger(String loggerName) {
        this(loggerName, false);
    }

    public Logger getLogInstance() {
        return this.logInstance;
    }

    @Override
    public void error(String logMessage, Object ... logArguments) {
        this.getLogInstance().severe(this.parse(logMessage, logArguments));
    }

    @Override
    public void warn(String logMessage, Object ... logArguments) {
        this.getLogInstance().warning(this.parse(logMessage, logArguments));
    }

    @Override
    public void info(String logMessage, Object ... logArguments) {
        this.getLogInstance().info(this.parse(logMessage, logArguments));
    }

    @Override
    public String getPrefix() {
        return this.appendName ? LegacyLogger.jvmdowngrader$concat$getPrefix$1(this.getLoggerName()) : "";
    }

    private static String jvmdowngrader$concat$getPrefix$1(String string) {
        return string + ": ";
    }
}

