/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import unilib.external.com.twelvemonkeys.lang.Validate;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int bytesWritten;

    public LittleEndianDataOutputStream(OutputStream outputStream) {
        super(Validate.notNull(outputStream, "stream"));
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        this.out.write(n2);
        ++this.bytesWritten;
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.bytesWritten += n3;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.out.write(n2);
        ++this.bytesWritten;
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >>> 8 & 0xFF);
        this.bytesWritten += 2;
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >>> 8 & 0xFF);
        this.bytesWritten += 2;
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 >>> 16 & 0xFF);
        this.out.write(n2 >>> 24 & 0xFF);
        this.bytesWritten += 4;
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.bytesWritten += 8;
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            this.out.write((byte)string.charAt(i));
        }
        this.bytesWritten += n2;
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
        }
        this.bytesWritten += n2 * 2;
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(n4 >>> 8 & 0xFF);
        this.out.write(n4 & 0xFF);
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
                this.bytesWritten += 2;
                continue;
            }
            this.out.write(0xC0 | c >> 6 & 0x1F);
            this.out.write(0x80 | c & 0x3F);
            ++this.bytesWritten;
        }
        this.bytesWritten += n3 + 2;
    }

    public int size() {
        return this.bytesWritten;
    }
}

