/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import unilib.external.com.twelvemonkeys.io.Seekable;
import unilib.external.com.twelvemonkeys.io.SeekableInputStream;
import unilib.external.com.twelvemonkeys.io.SeekableOutputStream;

public abstract class RandomAccessStream
implements Seekable,
DataInput,
DataOutput {
    SeekableInputStream inputView = null;
    SeekableOutputStream outputView = null;

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (byArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = this.read();
        if (n5 == -1) {
            return -1;
        }
        byArray[n2] = (byte)n5;
        try {
            for (n4 = 1; n4 < n3 && (n5 = this.read()) != -1; ++n4) {
                byArray[n2 + n4] = (byte)n5;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n4;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray != null ? byArray.length : 1);
    }

    public final SeekableInputStream asInputStream() {
        if (this.inputView == null) {
            this.inputView = new InputStreamView(this);
        }
        return this.inputView;
    }

    public final SeekableOutputStream asOutputStream() {
        if (this.outputView == null) {
            this.outputView = new OutputStreamView(this);
        }
        return this.outputView;
    }

    static final class OutputStreamView
    extends SeekableOutputStream {
        private final RandomAccessStream mStream;

        public OutputStreamView(RandomAccessStream randomAccessStream) {
            if (randomAccessStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = randomAccessStream;
        }

        @Override
        public boolean isCached() {
            return this.mStream.isCached();
        }

        @Override
        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        @Override
        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        @Override
        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        @Override
        protected void flushBeforeImpl(long l) throws IOException {
            this.mStream.flushBefore(l);
        }

        @Override
        protected void seekImpl(long l) throws IOException {
            this.mStream.seek(l);
        }

        @Override
        public void write(int n2) throws IOException {
            this.mStream.write(n2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.mStream.write(byArray, n2, n3);
        }
    }

    static final class InputStreamView
    extends SeekableInputStream {
        private final RandomAccessStream mStream;

        public InputStreamView(RandomAccessStream randomAccessStream) {
            if (randomAccessStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = randomAccessStream;
        }

        @Override
        public boolean isCached() {
            return this.mStream.isCached();
        }

        @Override
        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        @Override
        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        @Override
        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        @Override
        protected void flushBeforeImpl(long l) throws IOException {
            this.mStream.flushBefore(l);
        }

        @Override
        protected void seekImpl(long l) throws IOException {
            this.mStream.seek(l);
        }

        @Override
        public int read() throws IOException {
            return this.mStream.read();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.mStream.read(byArray, n2, n3);
        }
    }
}

