/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class SubStream
extends FilterInputStream {
    private long bytesLeft;
    private int markLimit;

    public SubStream(InputStream inputStream, long l) {
        super(Validate.notNull(inputStream, "stream"));
        this.bytesLeft = Validate.isTrue(l >= 0L, l, "length < 0: %s");
    }

    @Override
    public void close() throws IOException {
        while (this.bytesLeft > 0L && (this.skip(this.bytesLeft) > 0L || this.read() >= 0)) {
        }
    }

    @Override
    public int available() throws IOException {
        return (int)this.findMaxLen(super.available());
    }

    @Override
    public void mark(int n2) {
        super.mark(n2);
        this.markLimit = n2;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bytesLeft += (long)this.markLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft-- <= 0L) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.bytesLeft <= 0L) {
            return -1;
        }
        int n4 = super.read(byArray, n2, (int)this.findMaxLen(n3));
        this.bytesLeft = n4 < 0 ? 0L : this.bytesLeft - (long)n4;
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(this.findMaxLen(l));
        this.bytesLeft -= l2;
        return l2;
    }

    private long findMaxLen(long l) {
        return this.bytesLeft < l ? Math.max(this.bytesLeft, 0L) : l;
    }
}

