/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io.enc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import unilib.external.com.twelvemonkeys.io.enc.DecodeException;
import unilib.external.com.twelvemonkeys.io.enc.Decoder;

public final class PackBitsDecoder
implements Decoder {
    private final boolean disableNoOp;
    private final byte[] sample;
    private boolean reachedEOF;

    public PackBitsDecoder() {
        this(1, false);
    }

    public PackBitsDecoder(boolean bl) {
        this(1, bl);
    }

    public PackBitsDecoder(int n2, boolean bl) {
        this.sample = new byte[n2];
        this.disableNoOp = bl;
    }

    @Override
    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            this.reachedEOF = true;
            return 0;
        }
        byte by = (byte)n2;
        try {
            if (by >= 0) {
                PackBitsDecoder.readFully(inputStream, byteBuffer, this.sample.length * (by + 1));
            } else if (this.disableNoOp || by != -128) {
                int n3;
                for (n3 = 0; n3 < this.sample.length; ++n3) {
                    this.sample[n3] = PackBitsDecoder.readByte(inputStream);
                }
                for (n3 = -by + 1; n3 > 0; --n3) {
                    byteBuffer.put(this.sample);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DecodeException("Error in PackBits decompression, data seems corrupt", indexOutOfBoundsException);
        }
        return byteBuffer.position();
    }

    static byte readByte(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)n2;
    }

    static void readFully(InputStream inputStream, ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Negative length: %d", n2));
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Unexpected end of PackBits stream");
        }
        byteBuffer.position(byteBuffer.position() + n3);
    }
}

