/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import net.minecraft.class_1600;
import net.minecraft.class_1636;
import net.minecraft.class_1653;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={InputType.class})
public class ImageUtils {
    private static final BlockingQueue<Pair<String, Pair<InputType, Object>>> urlRequests = new LinkedBlockingQueue<Pair<String, Pair<InputType, Object>>>();
    private static final Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<class_1653>>> cachedImages = StringUtils.newConcurrentHashMap();
    private static boolean hasInitializedImageIO = false;

    public static class_1653 getTextureFromUrl(class_1600 instance, String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, URI.create(url).toURL());
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static class_1653 getTextureFromUrl(class_1600 instance, String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(InputType.Url, url));
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static class_1653 getTextureFromUrl(class_1600 instance, String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(InputType.FileData, url));
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static class_1653 getTextureFromUrl(class_1600 instance, String textureName, Object url) {
        if (url instanceof File) {
            File file = (File)url;
            return ImageUtils.getTextureFromUrl(instance, textureName, file);
        }
        if (url instanceof URL) {
            URL link = (URL)url;
            return ImageUtils.getTextureFromUrl(instance, textureName, link);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(instance, textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream, url.toString()));
    }

    public static class_1653 getTextureFromUrl(class_1600 instance, String textureName, Pair<InputType, Object> stream) {
        Pair<Integer, List<ImageFrame>> bufferData;
        if (!cachedImages.containsKey(textureName)) {
            cachedImages.put(textureName, new Tuple(stream, new Pair(0, StringUtils.newArrayList()), null));
            try {
                urlRequests.put(new Pair<String, Pair<InputType, Object>>(textureName, stream));
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
            }
        }
        if ((bufferData = cachedImages.get(textureName).getSecond()) == null || bufferData.getSecond() == null || bufferData.getSecond().isEmpty()) {
            return ResourceUtils.getEmptyResource();
        }
        if (textureName != null) {
            boolean isGif = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
            boolean isWebp = textureName.endsWith(".webp") || stream.getSecond().toString().contains("webp");
            boolean shouldRepeat = isGif || isWebp;
            boolean doesContinue = bufferData.getFirst() < bufferData.getSecond().size() - 1;
            List<class_1653> resources = cachedImages.get(textureName).getThird();
            if (bufferData.getFirst() < resources.size()) {
                class_1653 texLocation = resources.get(bufferData.getFirst());
                if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                    if (doesContinue) {
                        bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime();
                    } else if (shouldRepeat) {
                        bufferData.getSecond().get(bufferData.setFirst(0)).setRenderTime();
                    }
                }
                return texLocation;
            }
            try {
                class_1636 dynTexture = new class_1636(bufferData.getSecond().get(bufferData.getFirst()).getImage());
                class_1653 cachedTexture = instance.method_5570().method_5851(ImageUtils.jvmdowngrader$concat$getTextureFromUrl$1(textureName.toLowerCase(), shouldRepeat ? ImageUtils.jvmdowngrader$concat$getTextureFromUrl$1(String.valueOf(cachedImages.get(textureName).getSecond().getFirst())) : ""), dynTexture);
                if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                    if (doesContinue) {
                        bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime();
                    } else if (shouldRepeat) {
                        bufferData.setFirst(0);
                    }
                }
                if (!resources.contains(cachedTexture)) {
                    resources.add(cachedTexture);
                }
                return cachedTexture;
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                return ResourceUtils.getEmptyResource();
            }
        }
        return ResourceUtils.getEmptyResource();
    }

    private static /* synthetic */ void lambda$static$0() {
        block14: while (true) {
            try {
                while (!CoreUtils.IS_CLOSING) {
                    Pair<String, Pair<InputType, Object>> request = urlRequests.take();
                    boolean isGif = request.getFirst().endsWith(".gif");
                    boolean isWebp = request.getFirst().endsWith(".webp");
                    Pair<Integer, List<ImageFrame>> bufferData = cachedImages.get(request.getFirst()).getSecond();
                    if (bufferData == null) continue;
                    try {
                        ImageFrame[] frames;
                        InputStream streamData;
                        Object originData = request.getSecond().getSecond();
                        switch (request.getSecond().getFirst().ordinal()) {
                            case 0: {
                                streamData = Files.newInputStream(((File)originData).toPath(), new OpenOption[0]);
                                break;
                            }
                            case 1: {
                                streamData = Files.newInputStream(Paths.get(originData.toString(), new String[0]), new OpenOption[0]);
                                break;
                            }
                            case 2: {
                                byte[] byArray;
                                Tuple<Boolean, String, String> base64Data = StringUtils.isBase64(originData.toString());
                                if (base64Data.getFirst().booleanValue()) {
                                    byArray = ImageFrame.decodeBase64(base64Data.getThird(), "UTF-8", false, false);
                                } else if (originData instanceof byte[]) {
                                    byte[] byteData = (byte[])originData;
                                    byArray = byteData;
                                } else {
                                    byArray = StringUtils.getBytes(originData.toString());
                                }
                                byte[] dataSet = byArray;
                                streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                isGif = base64Data.getSecond().contains("gif");
                                isWebp = base64Data.getSecond().contains("webp");
                                break;
                            }
                            case 3: {
                                URL url;
                                streamData = UrlUtils.getURLStream(originData instanceof URL ? (url = (URL)originData) : URI.create(originData.toString()).toURL());
                                isGif = originData.toString().endsWith(".gif");
                                isWebp = originData.toString().endsWith(".webp");
                                break;
                            }
                            default: {
                                streamData = null;
                            }
                        }
                        if (streamData == null) continue block14;
                        if (!hasInitializedImageIO) {
                            ImageIO.scanForPlugins();
                            hasInitializedImageIO = true;
                        }
                        if (isGif) {
                            for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                try {
                                    bufferData.getSecond().add(frame);
                                }
                                catch (Throwable ex) {
                                    CoreUtils.LOG.debugError(ex);
                                }
                            }
                        } else if (isWebp) {
                            for (ImageFrame frame : frames = ImageFrame.readWebp(streamData)) {
                                try {
                                    bufferData.getSecond().add(frame);
                                }
                                catch (Throwable ex) {
                                    CoreUtils.LOG.debugError(ex);
                                }
                            }
                        } else {
                            bufferData.getSecond().add(new ImageFrame(ImageIO.read(streamData)));
                        }
                        cachedImages.get(request.getFirst()).setSecond(bufferData);
                        cachedImages.get(request.getFirst()).setThird(new ArrayList(bufferData.getSecond().size()));
                        continue block14;
                    }
                    catch (Throwable ex) {
                        CoreUtils.LOG.debugError(ex);
                    }
                }
                break;
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                break;
            }
        }
    }

    static {
        CoreUtils.getThreadFactory().newThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$static$0(), ()V)()).start();
    }

    private static String jvmdowngrader$concat$getTextureFromUrl$1(String string) {
        return "_" + string;
    }

    private static String jvmdowngrader$concat$getTextureFromUrl$1(String string, String string2) {
        return string + string2;
    }

    @NestHost(value=ImageUtils.class)
    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

