/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class NbtUtils {
    public static CompoundNBT getNbt(Entity entity) {
        CompoundNBT result = new CompoundNBT();
        return entity != null ? entity.func_189511_e(result) : result;
    }

    public static CompoundNBT getNbt(ItemStack stack) {
        CompoundNBT result = new CompoundNBT();
        return stack != null ? stack.func_77955_b(result) : result;
    }

    public static INBT getNbt(Object data, String ... path) {
        if (data instanceof Entity) {
            Entity entity = (Entity)data;
            return NbtUtils.getNbt(entity, path);
        }
        if (data instanceof ItemStack) {
            ItemStack stack = (ItemStack)data;
            return NbtUtils.getNbt(stack, path);
        }
        return null;
    }

    public static INBT getNbt(Entity entity, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(entity), path);
    }

    public static INBT getNbt(ItemStack stack, String ... path) {
        return NbtUtils.getNbt(NbtUtils.getNbt(stack), path);
    }

    public static INBT getNbt(CompoundNBT root, String ... path) {
        if (path == null || path.length == 0) {
            return root;
        }
        CompoundNBT currentTag = root;
        for (int i = 0; i < path.length; ++i) {
            if (currentTag instanceof CompoundNBT) {
                CompoundNBT compound = currentTag;
                currentTag = compound.func_74781_a(path[i]);
                continue;
            }
            if (currentTag instanceof ListNBT) {
                ListNBT list = (ListNBT)currentTag;
                int index = Integer.parseInt(path[i]);
                currentTag = list.get(index);
                continue;
            }
            if (i == path.length - 1) break;
            return null;
        }
        return currentTag;
    }

    public static Object parseTag(INBT tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.func_74732_a()) {
            case 1: {
                return ((ByteNBT)tag).func_150290_f();
            }
            case 2: {
                return ((ShortNBT)tag).func_150289_e();
            }
            case 3: {
                return ((IntNBT)tag).func_150287_d();
            }
            case 4: {
                return ((LongNBT)tag).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((FloatNBT)tag).func_150288_h());
            }
            case 6: {
                return ((DoubleNBT)tag).func_150286_g();
            }
            case 7: {
                return ((ByteArrayNBT)tag).func_150292_c();
            }
            case 8: {
                return ((StringNBT)tag).func_150285_a_();
            }
            case 9: {
                ListNBT list = (ListNBT)tag;
                List converted = StringUtils.newArrayList();
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        converted.add(NbtUtils.parseTag(list.get(i)));
                    }
                }
                return converted;
            }
            case 10: {
                try {
                    return FileUtils.toJsonData(tag.toString(), new FileUtils.Modifiers[0]);
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    return tag.toString();
                }
            }
            case 11: {
                return ((IntArrayNBT)tag).func_150302_c();
            }
            case 12: {
                return ((LongArrayNBT)tag).func_197652_h();
            }
        }
        return tag;
    }
}

