/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;

public class ModUtils {
    public static final String MCVersion = SharedConstants.m_183709_().m_132493_();
    public static final int MCProtocolID = SharedConstants.m_183709_().m_132495_();
    public static final String BRAND = CoreUtils.findGameBrand(ClientBrandRetriever.m_129629_());
    public static final TranslationUtils RAW_TRANSLATOR = CoreUtils.findGameTranslations(MCProtocolID);
    private static final Supplier<Minecraft> INSTANCE_GETTER = Minecraft::m_91087_;
    private static final BiConsumer<String, ResourceManagerReloadListener> RELOAD_LISTENER_HOOK = (id, listener) -> ((ReloadableResourceManager)ModUtils.getMinecraft().m_91098_()).m_7217_((PreparableReloadListener)listener);
    public static boolean CAN_USE_RELOAD_LISTENER = true;
    private static final BiConsumer<Minecraft, Runnable> MAIN_THREAD_EXECUTOR = BlockableEventLoop::execute;

    public static Supplier<Minecraft> getMinecraftSupplier() {
        return INSTANCE_GETTER;
    }

    public static Minecraft getMinecraft() {
        return ModUtils.getMinecraftSupplier().get();
    }

    public static String getLanguage(String fallback) {
        String result = ModUtils.getMinecraft().f_91066_ != null ? ModUtils.getMinecraft().f_91066_.f_92075_ : fallback;
        return result;
    }

    public static String getLanguage() {
        return ModUtils.getLanguage(CoreUtils.getDefaultLanguage());
    }

    public static void registerReloadListener(String id, ResourceManagerReloadListener listener) {
        if (!CAN_USE_RELOAD_LISTENER) {
            return;
        }
        RELOAD_LISTENER_HOOK.accept(id, listener);
    }

    public static void executeOnMainThread(Minecraft client, Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(client, event);
    }

    public static void executeOnMainThread(Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(ModUtils.getMinecraft(), event);
    }
}

